/*
 * Copyright (c) 2002-2010 Balabit
 * Copyright (c) 1998-2010 Balázs Scheidler
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 */

#include "alarms.h"
#include "messages.h"

#include <unistd.h>
#include <signal.h>
#include <string.h>

static gboolean sig_alarm_received = FALSE;
static gboolean alarm_pending = FALSE;

static void
sig_alarm_handler(int signo)
{
  sig_alarm_received = TRUE;
}

void
alarm_set(int timeout)
{
  if (G_UNLIKELY(alarm_pending))
    {
      msg_error("Internal error, alarm_set() called while an alarm is still active");
      return;
    }
  alarm(timeout);
  alarm_pending = TRUE;
}

void
alarm_cancel()
{
  alarm(0);
  sig_alarm_received = FALSE;
  alarm_pending = FALSE;
}

gboolean
alarm_has_fired()
{
  gboolean res = sig_alarm_received;
  return res;
}

void
alarm_init()
{
  struct sigaction sa;
  
  memset(&sa, 0, sizeof(sa));
  sa.sa_handler = sig_alarm_handler;
  sigaction(SIGALRM, &sa, NULL);
}
