FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:"

DEPENDS += " virtual/kernel"

#Add sky specific patch.
SRC_URI += "file://001-Sky-Specific-Changes-For-TinyProxy.patch"

EXTRA_OECONF += " \
    --disable-upstream \
    --disable-xtinyproxy \
    --disable-reverse \
    "

CFLAGS_append = " \
    -I ${STAGING_INCDIR}/sky/userspace/public/include/ \
    -DSKY \
    -DHAVE_SIGNAL_H \
    -DHAVE_SYS_WAIT_H \
    -DHAVE_STDIO_H \
    -DHAVE_STDLIB_H \
    -DHAVE_CTYPE_H \
    -DHAVE_ERRNO_H \
    -DHAVE_SYSEXITS_H \
    -DHAVE_STRING_H \
    -DHAVE_GRP_H \
    -DHAVE_PWD_H \
    -DHAVE_SYS_STAT_H \
    -DHAVE_UNISTD_H \
    -DHAVE_STDARG_H \
    -DHAVE_SYSLOG_H \
    -DHAVE_ASSERT_H \
    -DHAVE_MALLOC_H \
    -DHAVE_SYS_MMAN_H \
    -DHAVE_ARPA_INET_H \
    -DHAVE_REGEX_H \
    -DHAVE_FCNTL_H \
    -DHAVE_SYS_SOCKET_H \
    -DHAVE_NETDB_H \
    -DHAVE_SYS_TYPES_H \
    -DHAVE_STDDEF_H \
    -DFILTER_ENABLE \
    -DTRANSPARENT_PROXY \
    -DNDEBUG \
    -D_POSIX_C_SOURCE=200809L \
    "

do_configure[depends] = " virtual/kernel:do_install"


SYSTEMD_SERVICE_${PN}_remove = "tinyproxy.service"

#Remove systemd service as we are not using it.
do_install_append() {
    if ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'true', 'false', d)}; then
        if [ -f ${D}${systemd_system_unitdir}/tinyproxy.service ]; then
            rm -rf ${D}${systemd_system_unitdir}/tinyproxy.service
        fi
    fi
}

