do_make_scripts() {
        unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS
        make CC="${KERNEL_CC}" LD="${KERNEL_LD}" AR="${KERNEL_AR}" \
                   -C ${STAGING_KERNEL_DIR}/kernel/linux-4.1 O=${STAGING_KERNEL_BUILDDIR} scripts
}

EXTRA_OEMAKE +='-C "${STAGING_KERNEL_DIR}/kernel/linux-4.1" M="${S}" CFLAGS_MODULE+=-DNETLINK_NFLUA=16 INSTALL_MOD_DIR=lua CONFIG_LUNATIK=m CONFIG_LUADATA=m CONFIG_LUAKCRYPTO=m CONFIG_LUAJSON=m CONFIG_NFLUA=m CONFIG_NFLUA_LEGACY=m'

do_configure() {
    cp -r ${STAGING_KERNEL_DIR}/kernel/linux-4.1/arch/arm/mach-bcm963xx/include/mach/ ${STAGING_KERNEL_DIR}/kernel/linux-4.1/arch/arm/include/
}

do_install() {
        install -d ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/lib/luajson/luajson.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/lib/lunatik/lunatik.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/lib/luadata/luadata.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/lib/luakcrypto/luakcrypto.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/src/luaconntrack.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/src/nflua.ko ${D}/lib/modules/${KERNEL_VERSION}/
}
