#! /bin/sh

###################################################################################
#
# This file will create pppoe.conf and chap/pap secret files with the parameters 
# pased from pppmanager
#
####################################################################################

USER_NAME=$1
PASSWORD=$2
SERVICE_NAME=$3
INTERFACE_NAME=$4
CONNECTION_TYPE=$5

PPP_CHAP_SECRET_FILE=/etc/ppp/chap-secrets
PPP_PAP_SECRET_FILE=/etc/ppp/pap-secrets
PPP_CONFIG_FILE=/etc/ppp/pppoe.conf
PPP_OPTIONS_FILE=/etc/ppp/options
PPPOA_PLUGIN="/usr/lib/pppd/2.4.8/pppoatm.so"
PPPOE_PLUGIN="/usr/lib/pppd/2.4.8/rp-pppoe.so"
MAXMRUSIZE=1492
CONCENTRATOR=""
SERVICE=""
DEFLCPINTERVAL=30

if [ -z "$USER_NAME" ] || [ -z "$PASSWORD" ] || [ -z "$SERVICE_NAME" ] \
    || [ -z "$CONNECTION_TYPE" ] || [ -z "$INTERFACE_NAME" ]; then
    echo "Exiting...."
    exit 0
fi


if [ "$CONNECTION_TYPE" != "PPPoA" ] && [ "$CONNECTION_TYPE" != "PPPoE" ]; then
    echo "Wrong connection type . Exiting..."
fi

#make /etc/ppp write permission
mkdir /tmp/ppp
cp -rf /etc/ppp/* /tmp/ppp
mount -t tmpfs -o mode=0755 tmpfs /etc/ppp
cp -rf /tmp/ppp/* /etc/ppp/
rm -rf /tmp/ppp

#clear out existing files and configure required parameters only
rm -f $PPP_CONFIG_FILE
rm -f $PPP_OPTIONS_FILE

echo -n > $PPP_CONFIG_FILE
echo "MRU=$MAXMRUSIZE" >> $PPP_CONFIG_FILE
echo "USER=$USER_NAME" >>$PPP_CONFIG_FILE
echo "IFNAME=$INTERFACE_NAME" >>$PPP_CONFIG_FILE
echo "DEMAND=no" >> $PPP_CONFIG_FILE
echo "DNSTYPE=SERVER" >> $PPP_CONFIG_FILE
echo "PEERDNS=yes" >> $PPP_CONFIG_FILE
echo "DNS1=" >> $PPP_CONFIG_FILE
echo "DNS2=" >> $PPP_CONFIG_FILE
echo "DEFAULTROUTE=yes" >> $PPP_CONFIG_FILE
echo "CONNECT_TIMEOUT=0" >> $PPP_CONFIG_FILE
echo "CONNECT_POLL=2" >> $PPP_CONFIG_FILE
echo "ACNAME=$CONCENTRATOR" >> $PPP_CONFIG_FILE
echo "SERVICENAME=$SERVICE" >> $PPP_CONFIG_FILE
echo 'PING="."' >> $PPP_CONFIG_FILE
echo 'PIDFILE="/var/run/pppoe.pid"' >> $PPP_CONFIG_FILE
echo "SYNCHRONOUS=no" >> $PPP_CONFIG_FILE
echo "CLAMPMSS=1412" >> $PPP_CONFIG_FILE
echo "LCP_INTERVAL=$DEFLCPINTERVAL" >> $PPP_CONFIG_FILE
echo "LCP_FAILURE=3" >> $PPP_CONFIG_FILE
echo "PPPOE_TIMEOUT=80" >> $PPP_CONFIG_FILE
echo "FIREWALL=NONE" >> $PPP_CONFIG_FILE
echo 'PPPOE_EXTRA=""' >> $PPP_CONFIG_FILE
echo 'PPPD_EXTRA=""' >> $PPP_CONFIG_FILE
echo "CHAP_INTERVAL=8" >> $PPP_CONFIG_FILE
echo "CHAP_MAX_CHALLENGE=10" >> $PPP_CONFIG_FILE
echo "CHAP_RESTART=3" >> $PPP_CONFIG_FILE

if [ "$CONNECTION_TYPE" = "PPPoA" ]; then

    #Get VPI/VCI numbers
    VCI=$(echo "$SERVICE_NAME" | awk -F. '{print $NF}')

    atm=$(echo "$SERVICE_NAME" | cut -f1,1 -d'.')

    if [ "$atm" == "atm0" ]; then
        VPI=$(echo $atm | tail -c 2)
    fi

    #vpi/vci
    echo "ATM='$VPI.$VCI'" >> $PPP_CONFIG_FILE
    echo "VPI=$VPI" >> $PPP_CONFIG_FILE
    echo "VCI=$VCI" >> $PPP_CONFIG_FILE
    echo "PASSWORD=$PASSWORD" >> $PPP_CONFIG_FILE
    echo "LINUX_PLUGIN=\"$PPPOA_PLUGIN\"" >> $PPP_CONFIG_FILE
else
    echo "ETH='$SERVICE_NAME'" >> $PPP_CONFIG_FILE
    echo "LINUX_PLUGIN=\"$PPPOE_PLUGIN\"" >> $PPP_CONFIG_FILE
    echo "lock" >> $PPP_OPTIONS_FILE
fi
#configure the chap/pap secrets
echo "$USER_NAME * $PASSWORD *" > "$PPP_CHAP_SECRET_FILE"
echo "$USER_NAME * $PASSWORD *" > "$PPP_PAP_SECRET_FILE"
