# This file is Confidential Information of CUJO LLC.
# Copyright (c) 2020 CUJO LLC. All rights reserved.

SUMMARY = "Netfilter lua module (kernel)"
DESCRIPTION = ""
HOMEPAGE = "https://github.com/cujoai/nflua"
LICENSE = "MIT & GPLv2"

LIC_FILES_CHKSUM = "file://LICENSES;md5=ee3ff1baf4364261360a81e2efe0e4da"
DEPENDS = "virtual/kernel"

SRCREV = "b22c00527be3529be68fc5286fae8522f09af7af"

# Workaround to get submodules working correctly
python do_unpack_append() {
    import os
    dir = d.getVar('WORKDIR', True) + "/git"
    os.chdir(dir)
    os.system("sed -E -i.bak -e 's/git@github.com:/https:\/\/github.com\//g' .gitmodules")
    os.system("git submodule update --init --recursive")
}

SRC_URI = "git://github.com/cujoai/nflua.git"

SRC_URI_append = "\
    file://0100-Add-optional-binary-argument-to-encode.patch \
    file://0101-Add-optional-binary-argument-to-encode.patch \
"

S = "${WORKDIR}/git"

inherit module-base

addtask make_scripts after do_patch before do_compile
do_make_scripts[lockfiles] = "${TMPDIR}/kernel-scripts.lock"
do_make_scripts[deptask] = "do_populate_sysroot"
do_make_scripts[depends] += "virtual/kernel:do_shared_workdir"

# Ensure one recipe isn't running do_make_scripts
# whilst another is using those scripts in do_compile.
do_compile[lockfiles] = "${TMPDIR}/kernel-scripts.lock"

# The modules-base class has been reworked during the 'sumo' (v2.5)
# development cycle removing do_make_scripts. This empty task is needed
# to ensure compatibility with both newer and older Yocto versions
do_make_scripts_append_dunfell() {
}


do_make_scripts_append_kirkstone() {
}

NETLINK_NFLUA ?= "16"

# STAGING_ROOT is set to ${D} instead of ${STAGING_DIR_HOST} to avoid
# Makefile installing files directly into yocto's staging directory.
# Let the SYSROOT_DIRS do it's job automatically.
EXTRA_OEMAKE = "\
    BUILD_DIR=${S} \
    INSTALL_ROOT=${D} \
    STAGING_ROOT=${D} \
    CUJO_PREFIX=${CUJO_PREFIX} \
    KERNEL_HEADERS_DIR=${STAGING_KERNEL_DIR} \
    KERNEL_BINUTILS_PREFIX=${TARGET_PREFIX} \
    NETLINK_NFLUA=${NETLINK_NFLUA} \
    BUILD_XT=0 \
"

LDFLAGS = ""

TARGET_CC_ARCH += "${LDFLAGS}"

SYSROOT_DIRS += "${CUJO_PREFIX}"

do_install() {
    oe_runmake install
}

PACKAGES += "${PN}-tests"

FILES_${PN} += "\
    ${nonarch_base_libdir}/modules/*/luaconntrack.ko \
    ${nonarch_base_libdir}/modules/*/luadata.ko \
    ${nonarch_base_libdir}/modules/*/luakcrypto.ko \
    ${nonarch_base_libdir}/modules/*/luajson.ko \
    ${nonarch_base_libdir}/modules/*/lunatik.ko \
    ${nonarch_base_libdir}/modules/*/nflua.ko \
"

FILES_${PN}-dev += "\
    ${CUJO_PREFIX}/include/nflua \
"

FILES_${PN}-tests += "\
    ${CUJO_PREFIX}/share/nflua-tests/ \
    ${nonarch_base_libdir}/modules/*/lunatiktest.ko \
"
