SUMMARY = "Broadcom Oops Capture Kernel Driver"
DESCRIPTION = "Broadcom Oops Capture Kernel Driver"
SECTION = "console/utils"
LICENSE = "GPLv2"
INC_PR = "r3"
LIC_FILES_CHKSUM = "file://COPYING;md5=eb723b61539feef013de476e68b5c50a"

DEPENDS += " virtual/kernel bison-native bc-native "
PROVIDES += "boops-k"
RPROVIDES_${PN} += "kernel-module-boops-k"

SRC_URI = "${RDK_GENERIC_ROOT_GIT}/boops/soc/broadcom/common;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH}"
PV = "${RDK_RELEASE}+git${SRCPV}"
SRCREV = "${AUTOREV}"
S = "${WORKDIR}/git/boops-k"

LDFLAGS_append=" -Wall"
CFLAGS_append=" "
CFLAGS += " -Wall -Wno-unused-function"

do_configure[noexec] ="1"
do_compile[lockfiles] = "${TMPDIR}/kernel-scripts.lock"
do_configure[depends] = "virtual/kernel:do_install"

MAKE_TARGETS = "all"
MODULE_NAME = "boops"

inherit module

MOD_OPTS += "CROSS_COMPILE=${TARGET_PREFIX}"
MOD_OPTS += "EXTMODDIR=${S}"

EXTRA_OEMAKE +='-C "${STAGING_KERNEL_DIR}/kernel/linux-4.19" M="${S}" EXTRA_CFLAGS="-I ${STAGING_KERNEL_DIR}/kernel/bcmkernel/include"'

do_compile() {
    unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS
    export LINUX_VER_STR="$(make -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 ${MOD_OPTS} -s --no-print-directory kernelversion)"
    make -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 ${MOD_OPTS} BRCM_ALT_TOOLCHAIN_BASE=${WORKDIR} LINUX_VER_STR=${LINUX_VER_STR} scripts
    oe_runmake -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 M=${S} LINUX_VER_STR=${LINUX_VER_STR} modules
}

module_do_install() {
    install -d ${D}${includedir}
    bbnote "Copying boops_shared.h to ${includedir}"
    cp -f ${S}/source/boops_shared.h ${D}${includedir}

    install -d ${D}/lib/modules/${KERNEL_VERSION}/misc
    bbnote "Copying ${MODULE_NAME}.ko to ${D}/lib/modules/${KERNEL_VERSION}/misc"
    install -m 0644 ${S}/${MODULE_NAME}.ko ${D}/lib/modules/${KERNEL_VERSION}/misc/${MODULE_NAME}.ko
}
