#!/bin/sh

Apparmor_blocklist_dir="/mnt/data/pstore"
Apparmor_blocklist="${Apparmor_blocklist_dir}/Apparmor_blocklist"
PROFILES_DIR="/etc/apparmor.d/"
PROFILES_UNCONFINED_DIR="/etc/apparmor.d/unconfined/"
PARSER="/sbin/apparmor_parser"
SYSFS_AA_PATH="/sys/kernel/security/apparmor/profiles"
RDKLOGS="/var/log/messages"
Apparmor_defaults="/etc/apparmor/apparmor_defaults"
LoadedProfile_count=0

echo -n noquiet > /sys/module/apparmor/parameters/audit
if $PARSER -rC $PROFILES_DIR/etc.apparmor.apparmor_parse.sh; then
    echo -n "changeprofile apparmor_parse.sh" > /proc/self/attr/current
fi

[ -f /etc/device.properties ] && . /etc/device.properties
[ -f /lib/rdk/t2Shared_api.sh ] && . /lib/rdk/t2Shared_api.sh
[ -d "$Apparmor_blocklist_dir" ] && [ ! -f "$Apparmor_blocklist" ] && touch "$Apparmor_blocklist"

echo_t() {
    echo "$(date +"%y%m%d-%T.%6N") $1"
}

while read line; do
    mode=$(echo "$line" | cut -d ":" -f 2)
    process=$(echo "$line" | cut -d ":" -f 1)
    profile=$(ls -ltr "$PROFILES_DIR" | grep -w "$process" | awk '{print $9}')
    if [ -n "$profile" ]; then
        blocklist_process=$(grep -w "$process" "$Apparmor_blocklist" 2>/dev/null | grep -v '\.service.sp')
        blocklist_mode=$(echo "$blocklist_process" | awk -F ":" '{print $2}')
        if [ "$mode" = "enforce" ]; then
            if [ "$blocklist_mode" = "complain" ]; then
                $PARSER -rC $PROFILES_DIR/"$profile"
            elif [ "$blocklist_mode" != "disable" ]; then
                $PARSER -r $PROFILES_DIR/"$profile"
                LoadedProfile_count=$(( LoadedProfile_count + 1 ))
            elif [ "$blocklist_mode" = "disable" ] && [ "$process" != "global" ]; then
                $PARSER -rC $PROFILES_UNCONFINED_DIR/"$profile"
            fi
      elif [ "$mode" = "complain" ]  && [ "$blocklist_mode" != "disable" ]; then
              $PARSER -rC $PROFILES_DIR/"$profile"
      fi
    fi
done<$Apparmor_defaults

list=$(grep complain "$SYSFS_AA_PATH" | awk '{print $1}' | tr '\n' ',')
cnt=$(grep -c complain "$SYSFS_AA_PATH")
if [ -n "$list" ]; then
    echo_t "List of profiles in Apparmor-complain mode:$cnt,$list" >> $RDKLOGS
    t2ValNotify "APPARMOR_C_split" "$cnt,$list" &> /dev/null
fi

list=$(grep enforce "$SYSFS_AA_PATH" | awk '{print $1}' | tr '\n' ',')
cnt=$(grep -c enforce "$SYSFS_AA_PATH")
if [ -n "$list" ]; then
    echo_t "List of profiles in Apparmor-enforce mode:$cnt,$list" >> $RDKLOGS
    t2ValNotify "APPARMOR_E_split" "$cnt,$list" &> /dev/null
fi

if [ "$LoadedProfile_count" -ne "$cnt" ]; then
    echo_t "Mismatch in the number of loaded Apparmor profiles" >> $RDKLOGS
fi

if [ -f /etc/apparmor/aar_telemetry.sh ]; then
    sh /etc/apparmor/aar_telemetry.sh &
fi

