# RDK MANAGEMENT, LLC CONFIDENTIAL AND PROPRIETARY
# ============================================================================
# This file (and its contents) are the intellectual property of RDK Management, LLC.
# It may not be used, copied, distributed or otherwise  disclosed in whole or in
# part without the express written permission of RDK Management, LLC.
# ============================================================================
# Copyright (c) 2020 RDK Management, LLC. All rights reserved.
# ============================================================================

#!/bin/sh

UNII3_ENABLED_INSMOD_PARAM=" "

PCI=`lspci`



#check PCI device/vendor ID
if grep -q "17cb:1101" <<< "$PCI";
then
    echo -ne "Found PCI: $PCI\n"

    wifimac=$(/usr/bin/emmc_read_util wifimac  | awk 'NR==4')
    Intf0MacAddress=$(echo $wifimac | sed -e 's/://g')
    mkdir /tmp/wlan
    echo Intf0MacAddress=$Intf0MacAddress > /tmp/wlan/wlan_mac.bin
    echo END >> /tmp/wlan/wlan_mac.bin

    insmod /lib/modules/`uname -r`/extra/wlan_cnss_core_pcie.ko

    # get BOX_MODEL to set the wifi country code            
    if [ -f /etc/device.properties ];                       
    then                                        
        . /etc/device.properties                
        if [ "$BOX_MODEL" = "SKXI11AIS" -o "$BOX_MODEL" = "SKXI11AEISODE" ];
        then                              
            insmod /lib/modules/`uname -r`/extra/wlan.ko country_code=DE
            echo "Setting wlan country code to DE"
            # rm18666/rm18708: Commands to fix UL 2.4G 11b Adaptivity shutdown failures for EU / ETSI variants only:
            iwpriv wlan0 setUnitTestCmd 0x48 3 149 1 0
            echo -ne "Disabling SIFS Burst in wifi driver\n"
            # rm27012: Command to resolve UL 5G Adaptivity failure (max COT 6ms failure on OFDM6 fixed mod):
            iwpriv wlan0 setUnitTestCmd 0x47 2 2 1
            echo -ne "Disabling SIFS Burst in wifi driver for 5G\n"
        elif [ "$BOX_MODEL" = "SKXI11ADS" -o "$BOX_MODEL" = "SKXI11AEIMRUK" ];
        then                                                            
            insmod /lib/modules/`uname -r`/extra/wlan.ko country_code=GB
            echo "Setting wlan country code to GB"
            # rm18666/rm18708: Commands to fix UL 2.4G 11b Adaptivity shutdown failures for EU / ETSI variants only:
            iwpriv wlan0 setUnitTestCmd 0x48 3 149 1 0
            echo -ne "Disabling SIFS Burst in wifi driver\n"
            # rm27012: Command to resolve UL 5G Adaptivity failure (max COT 6ms failure on OFDM6 fixed mod):
            iwpriv wlan0 setUnitTestCmd 0x47 2 2 1
            echo -ne "Disabling SIFS Burst in wifi driver for 5G\n"

        elif [ "$BOX_MODEL" = "SKXI11ANS" -o "$BOX_MODEL" = "SKXI11AEIMRIT" -o "$BOX_MODEL"  = "SKXI11AENSOIT" ];
        then                                                            
            insmod /lib/modules/`uname -r`/extra/wlan.ko country_code=IT
            echo "Setting wlan country code to IT"
            # rm18666/rm18708: Commands to fix UL 2.4G 11b Adaptivity shutdown failures for EU / ETSI variants only:
            iwpriv wlan0 setUnitTestCmd 0x48 3 149 1 0
            echo -ne "Disabling SIFS Burst in wifi driver\n"
            # rm27012: Command to resolve UL 5G Adaptivity failure (max COT 6ms failure on OFDM6 fixed mod):
            iwpriv wlan0 setUnitTestCmd 0x47 2 2 1
            echo -ne "Disabling SIFS Burst in wifi driver for 5G\n"
        elif [ "$BOX_MODEL" = "SCXI11AIC" -o "$BOX_MODEL" = "WNXI11AEI" ];
        then                                                            
            insmod /lib/modules/`uname -r`/extra/wlan.ko country_code=US
            echo "Setting wlan country code to US"                     
	elif [ "$BOX_MODEL" = "SKXI11ADSSOFT" ];
        then
            insmod /lib/modules/`uname -r`/extra/wlan.ko country_code=AU
	    echo "Setting wlan country code to AU"
    
        else                                                            
            echo "Skipping wlan country code. BOX_MODEL unknown or not set in device.properties"
            insmod /lib/modules/`uname -r`/extra/wlan.ko                                        
        fi                                                                                      
    else                                                                                        
        echo "Skipping wlan country code. /etc/device.properties not found"
        insmod /lib/modules/`uname -r`/extra/wlan.ko                       
    fi

else
    if grep -q "10ec:b852" <<< "$PCI";
    then
        wifimac=$(/usr/bin/emmc_read_util wifimac | awk 'NR==4')
        echo -ne "Found Realtek PCI Wi-Fi chip RTL8852BE: $PCI, MAC Address: $wifimac\n"
        insmod /lib/modules/`uname -r`/extra/8852be.ko rtw_drv_log_level=3 rtw_rfe_type=2 rtw_initmac=$wifimac
    elif [ -e /lib/rdk/loadWifiDrivers.sh ];
    then
        echo -ne "Loading Realtek drivers\n"
        source /lib/rdk/loadWifiDrivers.sh
    fi
fi

#check wlan kernel module loaded or not
loop=0
while [ -z $(lsmod | grep 'wlan' | head -n 1 | awk '{print $1}') ];
do
loop=$((loop+1))
if [ $loop = 5 ]
then
    echo "wlan kernel module not loaded:Exiting wifi.service with failed state"
    exit 1
else
    sleep 1
fi
done
