 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2021 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayesh.patel@broadcom.com>
 *****************************************************************************/
#include <linux/etherdevice.h>
#include "dqnet.h"
#include "dqnet_priv.h"
#include "dqnet_dbg.h"
#include "dqnet_svtag.h"
#include "fpm.h"

static inline void memmoveb(void *dst, const void *src, int len)
{
	char *d = (char *) (dst + len - 1);
	char *s = (char *) (src + len - 1);
	while (len--)
		*d-- = *s--;
}

static inline void memmovef(void *dst, const void *src, int len)
{
	char *d = (char *) (dst);
	char *s = (char *) (src);
	while (len--)
		*d++ = *s++;
}

int dqnet_rm_sv_tag(struct dqnet_netdev *ndev, struct fpm_buff *fb)
{
	int status = 0;
	u8 *tag;

	if (!fb->sv_tag_len)
		goto done;

	if (fb->type == BUF_TYPE_FPM)
		tag = fb->data + 2*ETH_ALEN;
	else
		tag = fb->skb->data + 2*ETH_ALEN;

	if (fb->type == BUF_TYPE_FPM) {
		memmoveb(fb->data + SV_TAG_LEN, fb->data, 2*ETH_ALEN);
		fb->data += SV_TAG_LEN;
		fb->offset += SV_TAG_LEN;
		fb->len -= SV_TAG_LEN;
	} else {
		memmoveb(fb->skb->data + SV_TAG_LEN, fb->skb->data, 2*ETH_ALEN);
		skb_pull(fb->skb, SV_TAG_LEN);
	}

	fb->sv_tag_len = 0;

done:
	return status;
}

int dqnet_add_sv_tag(struct dqnet_netdev *ndev, struct fpm_buff *fb)
{
	int status = 0;
	struct ethhdr *hdr;
	u8 *tag;

	if (!fb->sv_tag_len)
		goto done;

	if (fb->type == BUF_TYPE_FPM) {
		fb->data -= fb->sv_tag_len;
		fb->offset -= fb->sv_tag_len;
		fb->len += fb->sv_tag_len;
		memmovef(fb->data, fb->data + fb->sv_tag_len, 2*ETH_ALEN);
			tag = fb->data + 2*ETH_ALEN;
			hdr = (struct ethhdr *) fb->data;
	} else {
		if (skb_headroom(fb->skb) >= fb->sv_tag_len) {
			skb_push(fb->skb, fb->sv_tag_len);
			memmovef(fb->skb->data,
			fb->skb->data + fb->sv_tag_len,
					2*ETH_ALEN);
					tag = fb->skb->data + 2*ETH_ALEN;
		} else {
			struct sk_buff *new_skb;
			new_skb = skb_realloc_headroom(fb->skb,
										  fb->sv_tag_len);
			dev_kfree_skb(fb->skb);
			if (!new_skb)
				return -1;
			fb->skb = new_skb;
			skb_push(fb->skb, fb->sv_tag_len);
			memmovef(fb->skb->data,
					 fb->skb->data + fb->sv_tag_len,
					 2*ETH_ALEN);
			tag = fb->skb->data + 2*ETH_ALEN;
		}
		hdr = eth_hdr(fb->skb);
	}

	memcpy(tag, &ndev->svtag, fb->sv_tag_len);

done:
	return status;
}
