/****************************************************************************
*
* Broadcom Proprietary and Confidential. (c) 2020 Broadcom.
* All rights reserved.
* The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
*
* Unless you and Broadcom execute a separate written software license
* agreement governing use of this software, this software is licensed to
* you under the terms of the GNU General Public License version 2 (the
* "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
* the following added to such license:
*
* As a special exception, the copyright holders of this software give you
* permission to link this software with independent modules, and to copy
* and distribute the resulting executable under terms of your choice,
* provided that you also meet, for each linked independent module, the
* terms and conditions of the license of that module. An independent
* module is a module which is not derived from this software. The special
* exception does not apply to any modifications of the software.
*
* Notwithstanding the above, under no circumstances may you combine this
* software in any way with any other Broadcom software provided under a
* license other than the GPL, without Broadcom's express prior written
* consent.
*
****************************************************************************
*
* Filename: miimdiomux339x.h
*
****************************************************************************
* Description: RGMII and MDIO Mux Init header for BCM339x
* Author: Mark Newcomer <mark.newcomer@broadcom.com>
****************************************************************************/

#ifndef _MIIMDIOMUX_H
#define _MIIMDIOMUX_H

#include <linux/regulator/bcm-fixed.h>

#define MUX_MAX_NAME_LEN	32
#define MUX_MAX_VALUES		4

struct miimdiomux_priv {
	unsigned int *kmagic;
	bcm_fixed_notify notify;
	void __iomem *mdio_enb_reg;
};

struct mux_value {
	char name[MUX_MAX_NAME_LEN];
	int val;
};

struct mux_select {
	char name[MUX_MAX_NAME_LEN];
	char reg_name[MUX_MAX_NAME_LEN];
	u32 mask;
	int shift;
	struct mux_value value_map[MUX_MAX_VALUES];
	int value_map_size;
};
#endif
