/****************************************************************************
 *
 * Copyright (c) 2015-2018 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayeshp@broadcom.com>
 ***************************************************************************/

#ifndef _FLOWMGR_TUNNEL_H
#define _FLOWMGR_TUNNEL_H

#include <linux/netfilter.h>

struct flow_iptun_params {
	struct ethhdr		eh;		/* Ethernet Header        */
	union nf_inet_addr	laddr;
	union nf_inet_addr	raddr;
	__u8			tos;
	__u8			ttl;
	__be16			frag_off;
	__be16			vlan_tag;
	__be16			iphid;
	unsigned int		mtu;
};

struct flowmgr_tdb_entry {
	struct hlist_node	hlist;

	struct rcu_head		rcu;
	unsigned long		created;
	unsigned short		type;
	unsigned short		group;           /* group for GRE search */
	unsigned short		domain;		 /* Domain for MAP search  */
	int			id;
	__u8			state;
	atomic_t		use;             /* Use count              */
	int			ifi;             /* Interface Index        */
	int			oif;             /* Output Interface Index */
	union {
		struct flow_iptun_params parms;
		struct flow_mapt_params mapt;
	};
	u8			wifi_mask;
	int			wifi_flowring[8];
	u8			wifi_pri[8];
	const struct net_device_ops *netdev_ops;
};

int flowmgr_tunnel_init(void);
void flowmgr_tunnel_fini(void);
int flowmgr_tunnel_insert(struct net_device *dev);
int flowmgr_tunnel_mapt_insert(struct net_device *dev,
			       struct flow_mapt_params *params);
void flowmgr_tunnel_mapt_delete(int domain);
int flowmgr_tunnel_insert_v4link(struct net_device *dev, struct sk_buff *skb,
				 struct nf_conn_offload *ct_offload);
int flowmgr_tunnel_insert_v6link(struct net_device *dev, struct sk_buff *skb,
				 struct nf_conn_offload *ct_offload);
int flowmgr_tunnel_delete(struct net_device *dev);
int flowmgr_tunnel_update(int ifindex, int oif,
			  const unsigned char *h_dest,
			  const unsigned char *h_source,
			  __be16 h_vlan_TCI);
int flowmgr_tunnel_process(struct sk_buff *skb,
			   const struct net_device *in,
			   const struct net_device *out,
			   int protonum);
int  flowmgr_tunnel_out_ifindex(const struct net_device *dev,
				struct flow_tunnel_params *tunnel,
				struct flow_wifi_params *wifi);
int  flowmgr_tunnelid_out_ifindex(const struct net_device *dev, int id,
				  struct flow_tunnel_params *params,
				  struct flow_wifi_params *wifi);
void flowmgr_tdb_flush(void);
struct hlist_node  *flowmgr_tdb_get_first(int *hashid);
struct hlist_node *flowmgr_tdb_get_next(int *hashid,
					struct hlist_node *head);
struct hlist_node *flowmgr_tdb_get_idx(int *hashid, loff_t pos);
struct flowmgr_tdb_entry *flowmgr_tdb_find_by_raddr(__be32 *addr);
struct flowmgr_tdb_entry *flowmgr_tdb_find_by_cat(__u8 cat);
struct flowmgr_tdb_entry *flowmgr_tdb_find(int index);
struct flowmgr_tdb_entry *flowmgr_tunnel_find_mapt_domain(int domain);

#endif
