 /****************************************************************************
 *
 * Copyright (c) 2021 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayeshp@broadcom.com>
 ****************************************************************************/

#ifdef CONFIG_BCM_KF_CM

#include <linux/kernel.h>
#include <linux/module.h>
#include <net/netfilter/nf_conntrack_offload.h>

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Broadcom");
MODULE_DESCRIPTION("Skip Conntrack Offload Processing");
MODULE_ALIAS("ipt_SKIPCTOFFLOAD");

static unsigned int
skipctoffload_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
        nf_ct_offload_skip(skb);
        return XT_CONTINUE;
}

static struct xt_target skipctoffload_tg_reg __read_mostly = {
        .name           = "SKIPCTOFFLOAD",
        .revision   = 0,
        .family         = NFPROTO_UNSPEC,
        .target         = skipctoffload_tg,
        .me             = THIS_MODULE,
};

static int __init skipctoffload_tg_init(void)
{
        return xt_register_target(&skipctoffload_tg_reg);
}

static void __exit skipctoffload_tg_exit(void)
{
        xt_unregister_target(&skipctoffload_tg_reg);
}

module_init(skipctoffload_tg_init);
module_exit(skipctoffload_tg_exit);

#endif /* CONFIG_BCM_KF_CM */
