#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/kthread.h>
#include <linux/spinlock.h>
#include <linux/bug.h>
#include <linux/delay.h>

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Changseob.kim@broadcom.com");
MODULE_DESCRIPTION("A simple module for intentional hard lockup");
MODULE_VERSION("0.1");

static DEFINE_SPINLOCK(g_testlock);
static struct task_struct *lockup_thread[8];

static int hard_lockup_thread(void *data)
{
    //printk("%s: Waiting for 1 secs before start ... on CPU [%d]\n", __func__, smp_processor_id());
    msleep (1*1000);
    printk("%s: Trying spin_lock ... on CPU [%d]\n", __func__, smp_processor_id());
    spin_lock_irq(&g_testlock);

    /* We should not reach here */
    BUG();

    return 0;
}

static int __init hard_lockup_init(void)
{
    int i;
    char thread_name[8];

    printk ("%s: start\n", __func__);

    /* Aquire spin_lock here, so that the kthreads should busy-wait */
    spin_lock(&g_testlock);

    /* Create kthreads per CPU */
    for (i=0; i<num_online_cpus(); i++) {
        snprintf(thread_name, 8, "slt%d", i);
        //lockup_thread[i] = kthread_create_on_cpu(hard_lockup_thread, NULL, i, thread_name);
        lockup_thread[i] = kthread_create(hard_lockup_thread, NULL, thread_name);
        if (lockup_thread[i]) {
            kthread_bind(lockup_thread[i], i);
        }
    }

    /* Start kthreads */
    for (i=0; i<num_online_cpus(); i++) {
        if (lockup_thread[i]) {
            wake_up_process(lockup_thread[i]);
        }
    }

    printk ("%s: end\n", __func__);
    return 0;
}

static void __exit hard_lockup_exit(void)
{
    int i;

    printk ("%s: start\n", __func__);

    /* stop kthreads */
    for (i=0; i<num_online_cpus(); i++) {
        if (lockup_thread[i]) {
            kthread_stop(lockup_thread[i]);
        }
    }

    printk ("%s: end\n", __func__);
}

module_init(hard_lockup_init);
module_exit(hard_lockup_exit);
