#!/bin/sh
enable=0
AA_DEFAULT=/etc/apparmor/apparmor_defaults
DMSG_LOG=/opt/logs/dmesg_log.txt
AAR_ENTRY_CNT=/tmp/aar_marker.txt
AAR_MESG_LOG=/tmp/aar_msg.txt
ACTIVE_PROFILES=`cat /sys/kernel/security/apparmor/profiles`
loop_time=7200

if [ -f /lib/rdk/t2Shared_api.sh ]; then
    source /lib/rdk/t2Shared_api.sh
fi

if [ ! -z "$ACTIVE_PROFILES" ]; then
     enable=1
fi
while [ $enable -eq 1 ]
do
   nice -n 19 dmesg -cr > ${AAR_MESG_LOG}
   while read line; do
         profile=`echo $line | cut -d : -f1`
         count=`cat $AAR_MESG_LOG | grep profile | grep $profile | wc -l`;
         line=$count,
         echo -n $line >> $AAR_ENTRY_CNT
   done  < $AA_DEFAULT
   echo -n -e "`date "+%Y-%m-%dT%T"` APPARMOR_ENTRY_COUNT`cat $AAR_ENTRY_CNT`\n" >> ${DMSG_LOG}
   t2ValNotify "AA_ENTRY_split" "$AAR_ENTRY_CNT"
   rm -f ${AAR_MESG_LOG}
   rm -f ${AAR_ENTRY_CNT}
   sleep $loop_time
done
