/* valaccode.c generated by valac, the Vala compiler
 * generated from valaccode.vala, do not modify */

/* valaccode.vala
 *
 * Copyright (C) 2017  Rico Tzschichholz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Rico Tzschichholz <ricotz@ubuntu.com>
 */

#include <glib.h>
#include <vala.h>
#include "valacodegen.h"
#include <string.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>

#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_attribute_cache_unref0(var) ((var == NULL) ? NULL : (var = (vala_attribute_cache_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

VALA_EXTERN gint* vala_ccode_attribute_cache_index;
gint* vala_ccode_attribute_cache_index = NULL;

 G_GNUC_INTERNAL ValaCCodeAttribute* vala_get_ccode_attribute (ValaCodeNode* node);
static gint* _int_dup (gint* self);

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

 G_GNUC_INTERNAL ValaCCodeAttribute*
vala_get_ccode_attribute (ValaCodeNode* node)
{
	gint* _tmp0_;
	ValaAttributeCache* attr = NULL;
	gint* _tmp3_;
	ValaAttributeCache* _tmp4_;
	ValaAttributeCache* _tmp5_;
	ValaAttributeCache* _tmp10_;
	ValaCCodeAttribute* result;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_ccode_attribute_cache_index;
	if (_tmp0_ == NULL) {
		gint _tmp1_;
		gint* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_cache_index ();
		_tmp2_ = __int_dup0 (&_tmp1_);
		_g_free0 (vala_ccode_attribute_cache_index);
		vala_ccode_attribute_cache_index = _tmp2_;
		vala_ccode_base_module_init ();
	}
	_tmp3_ = vala_ccode_attribute_cache_index;
	_tmp4_ = vala_code_node_get_attribute_cache (node, *_tmp3_);
	attr = _tmp4_;
	_tmp5_ = attr;
	if (_tmp5_ == NULL) {
		ValaCCodeAttribute* new_attr = NULL;
		ValaCCodeAttribute* _tmp6_;
		gint* _tmp7_;
		ValaCCodeAttribute* _tmp8_;
		ValaCCodeAttribute* _tmp9_;
		_tmp6_ = vala_ccode_attribute_new (node);
		new_attr = _tmp6_;
		_tmp7_ = vala_ccode_attribute_cache_index;
		_tmp8_ = new_attr;
		vala_code_node_set_attribute_cache (node, *_tmp7_, (ValaAttributeCache*) _tmp8_);
		_tmp9_ = new_attr;
		attr = (ValaAttributeCache*) _tmp9_;
		_vala_attribute_cache_unref0 (new_attr);
	}
	_tmp10_ = attr;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CCODE_ATTRIBUTE, ValaCCodeAttribute);
	return result;
}

gchar*
vala_get_ccode_name (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_const_name (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_const_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_type_name (ValaObjectTypeSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_type_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_type_cast_function (ValaObjectTypeSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (!_tmp0_, "!(sym is Class && ((Class) sym).is_compact)");
	_tmp3_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sym, NULL);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_type_get_function (ValaObjectTypeSymbol* sym)
{
	gchar* func_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "type_get_function", NULL);
	func_name = _tmp0_;
	_tmp1_ = func_name;
	if (_tmp1_ != NULL) {
		result = func_name;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		_tmp3_ = _tmp2_;
		_vala_assert (!_tmp3_, "!((Class) sym).is_compact");
		_tmp4_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sym, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s_GET_CLASS", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		result = _tmp7_;
		_g_free0 (func_name);
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_INTERFACE)) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sym, NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf ("%s_GET_INTERFACE", _tmp9_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			result = _tmp11_;
			_g_free0 (func_name);
			return result;
		} else {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "`CCode.type_get_function' not supported");
			_tmp14_ = g_strdup ("");
			result = _tmp14_;
			_g_free0 (func_name);
			return result;
		}
	}
}

gchar*
vala_get_ccode_class_get_private_function (ValaClass* cl)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (cl != NULL, NULL);
	_tmp0_ = vala_class_get_is_compact (cl);
	_tmp1_ = _tmp0_;
	_vala_assert (!_tmp1_, "!cl.is_compact");
	_tmp2_ = vala_get_ccode_upper_case_name ((ValaSymbol*) cl, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s_GET_CLASS_PRIVATE", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

gchar*
vala_get_ccode_class_type_function (ValaClass* cl)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (cl != NULL, NULL);
	_tmp0_ = vala_class_get_is_compact (cl);
	_tmp1_ = _tmp0_;
	_vala_assert (!_tmp1_, "!cl.is_compact");
	_tmp2_ = vala_get_ccode_upper_case_name ((ValaSymbol*) cl, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s_CLASS", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
vala_get_ccode_lower_case_name (ValaCodeNode* node,
                                const gchar* infix)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	gchar* result;
	g_return_val_if_fail (node != NULL, NULL);
	sym = G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_SYMBOL) ? ((ValaSymbol*) node) : NULL;
	_tmp0_ = sym;
	if (_tmp0_ != NULL) {
		ValaSymbol* _tmp1_;
		if (infix == NULL) {
			infix = "";
		}
		_tmp1_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_DELEGATE)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			ValaSymbol* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp2_ = sym;
			_tmp3_ = vala_symbol_get_parent_symbol (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_get_ccode_lower_case_prefix (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = sym;
			_tmp8_ = vala_symbol_get_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_symbol_camel_case_to_lower_case (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup_printf ("%s%s%s", _tmp6_, infix, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			result = _tmp13_;
			return result;
		} else {
			ValaSymbol* _tmp14_;
			_tmp14_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_SIGNAL)) {
				ValaSymbol* _tmp15_;
				ValaCCodeAttribute* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp15_ = sym;
				_tmp16_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp15_);
				_tmp17_ = vala_ccode_attribute_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = string_replace (_tmp18_, "-", "_");
				result = _tmp19_;
				return result;
			} else {
				ValaSymbol* _tmp20_;
				_tmp20_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_ERROR_CODE)) {
					ValaSymbol* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp21_ = sym;
					_tmp22_ = vala_get_ccode_name ((ValaCodeNode*) _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_ascii_strdown (_tmp23_, (gssize) -1);
					_tmp25_ = _tmp24_;
					_g_free0 (_tmp23_);
					result = _tmp25_;
					return result;
				} else {
					ValaSymbol* _tmp26_;
					ValaSymbol* _tmp27_;
					ValaSymbol* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					ValaSymbol* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					_tmp26_ = sym;
					_tmp27_ = vala_symbol_get_parent_symbol (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = vala_get_ccode_lower_case_prefix (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = sym;
					_tmp32_ = vala_get_ccode_lower_case_suffix (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strdup_printf ("%s%s%s", _tmp30_, infix, _tmp33_);
					_tmp35_ = _tmp34_;
					_g_free0 (_tmp33_);
					_g_free0 (_tmp30_);
					result = _tmp35_;
					return result;
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_ERROR_TYPE)) {
			ValaErrorType* type = NULL;
			ValaErrorType* _tmp36_;
			ValaErrorDomain* _tmp37_;
			ValaErrorDomain* _tmp38_;
			type = G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_ERROR_TYPE, ValaErrorType);
			_tmp36_ = type;
			_tmp37_ = vala_error_type_get_error_domain (_tmp36_);
			_tmp38_ = _tmp37_;
			if (_tmp38_ == NULL) {
				if (infix == NULL) {
					gchar* _tmp39_;
					_tmp39_ = g_strdup ("g_error");
					result = _tmp39_;
					return result;
				} else {
					gchar* _tmp40_;
					_tmp40_ = g_strdup_printf ("g_%s_error", infix);
					result = _tmp40_;
					return result;
				}
			} else {
				ValaErrorType* _tmp41_;
				ValaErrorCode* _tmp42_;
				ValaErrorCode* _tmp43_;
				_tmp41_ = type;
				_tmp42_ = vala_error_type_get_error_code (_tmp41_);
				_tmp43_ = _tmp42_;
				if (_tmp43_ == NULL) {
					ValaErrorType* _tmp44_;
					ValaErrorDomain* _tmp45_;
					ValaErrorDomain* _tmp46_;
					gchar* _tmp47_;
					_tmp44_ = type;
					_tmp45_ = vala_error_type_get_error_domain (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp46_, infix);
					result = _tmp47_;
					return result;
				} else {
					ValaErrorType* _tmp48_;
					ValaErrorCode* _tmp49_;
					ValaErrorCode* _tmp50_;
					gchar* _tmp51_;
					_tmp48_ = type;
					_tmp49_ = vala_error_type_get_error_code (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp50_, infix);
					result = _tmp51_;
					return result;
				}
			}
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegateType* type = NULL;
				ValaDelegateType* _tmp52_;
				ValaDelegate* _tmp53_;
				ValaDelegate* _tmp54_;
				gchar* _tmp55_;
				type = G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
				_tmp52_ = type;
				_tmp53_ = vala_delegate_type_get_delegate_symbol (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp54_, infix);
				result = _tmp55_;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_POINTER_TYPE)) {
					ValaPointerType* type = NULL;
					ValaPointerType* _tmp56_;
					ValaDataType* _tmp57_;
					ValaDataType* _tmp58_;
					gchar* _tmp59_;
					type = G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_POINTER_TYPE, ValaPointerType);
					_tmp56_ = type;
					_tmp57_ = vala_pointer_type_get_base_type (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp58_, infix);
					result = _tmp59_;
					return result;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_GENERIC_TYPE)) {
						gchar* _tmp60_;
						_tmp60_ = g_strdup ("valageneric");
						result = _tmp60_;
						return result;
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_VOID_TYPE)) {
							gchar* _tmp61_;
							_tmp61_ = g_strdup ("valavoid");
							result = _tmp61_;
							return result;
						} else {
							ValaDataType* type = NULL;
							ValaDataType* _tmp62_;
							ValaTypeSymbol* _tmp63_;
							ValaTypeSymbol* _tmp64_;
							gchar* _tmp65_;
							type = G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_DATA_TYPE, ValaDataType);
							_tmp62_ = type;
							_tmp63_ = vala_data_type_get_type_symbol (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp64_, infix);
							result = _tmp65_;
							return result;
						}
					}
				}
			}
		}
	}
}

gchar*
vala_get_ccode_upper_case_name (ValaSymbol* sym,
                                const gchar* infix)
{
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp0_ = vala_symbol_get_parent_symbol (sym);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_symbol_get_name (sym);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_camel_case_to_lower_case (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%s_%s", _tmp3_, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_ascii_strup (_tmp9_, (gssize) -1);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp3_);
		result = _tmp11_;
		return result;
	} else {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) sym, infix);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_ascii_strup (_tmp13_, (gssize) -1);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		result = _tmp15_;
		return result;
	}
}

gchar*
vala_get_ccode_header_filenames (ValaSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_header_filenames (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_feature_test_macros (ValaSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_feature_test_macros (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_prefix (ValaSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_prefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_lower_case_prefix (ValaSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_lower_case_prefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_lower_case_suffix (ValaSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_lower_case_suffix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_ref_function (ValaTypeSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_ref_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_quark_name (ValaErrorDomain* edomain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (edomain != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "_", "-");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s-quark", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gboolean
vala_is_reference_counting (ValaTypeSymbol* sym)
{
	gboolean result;
	g_return_val_if_fail (sym != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = vala_get_ccode_ref_function (sym);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_ != NULL;
		_g_free0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_INTERFACE)) {
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
}

gboolean
vala_is_ref_function_void (ValaDataType* type)
{
	ValaClass* cl = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaClass* _tmp2_;
	gboolean result;
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (type);
	_tmp1_ = _tmp0_;
	cl = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1_) : NULL;
	_tmp2_ = cl;
	if (_tmp2_ != NULL) {
		ValaClass* _tmp3_;
		_tmp3_ = cl;
		result = vala_get_ccode_ref_function_void (_tmp3_);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
vala_is_free_function_address_of (ValaDataType* type)
{
	ValaClass* cl = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaClass* _tmp2_;
	gboolean result;
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (type);
	_tmp1_ = _tmp0_;
	cl = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1_) : NULL;
	_tmp2_ = cl;
	if (_tmp2_ != NULL) {
		ValaClass* _tmp3_;
		_tmp3_ = cl;
		result = vala_get_ccode_free_function_address_of (_tmp3_);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
vala_get_ccode_ref_function_void (ValaClass* cl)
{
	ValaCCodeAttribute* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) cl);
	_tmp1_ = vala_ccode_attribute_get_ref_function_void (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
vala_get_ccode_free_function_address_of (ValaClass* cl)
{
	ValaCCodeAttribute* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) cl);
	_tmp1_ = vala_ccode_attribute_get_free_function_address_of (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gchar*
vala_get_ccode_unref_function (ValaObjectTypeSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_unref_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_ref_sink_function (ValaObjectTypeSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_ref_sink_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_copy_function (ValaTypeSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_copy_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_destroy_function (ValaTypeSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_destroy_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_dup_function (ValaTypeSymbol* sym)
{
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
		ValaCCodeAttribute* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
		_tmp1_ = vala_ccode_attribute_get_dup_function (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = vala_get_ccode_copy_function (sym);
	result = _tmp4_;
	return result;
}

gchar*
vala_get_ccode_free_function (ValaTypeSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_free_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
vala_get_ccode_is_gboxed (ValaTypeSymbol* sym)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_get_ccode_free_function (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "g_boxed_free") == 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
vala_get_ccode_finish_instance (ValaMethod* m)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = vala_method_get_coroutine (m);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_, "m.coroutine");
	_tmp2_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp3_ = vala_ccode_attribute_get_finish_instance (_tmp2_);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}

gchar*
vala_get_ccode_type_id (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_type_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_type_function (ValaTypeSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		_tmp4_ = _tmp3_;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_CODE);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE);
	}
	_vala_assert (!_tmp0_, "!((sym is Class && ((Class) sym).is_compact) || sym is ErrorCode || sym is Delegate)");
	_tmp5_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) sym, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s_get_type", _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	result = _tmp8_;
	return result;
}

gchar*
vala_get_ccode_marshaller_type_name (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_marshaller_type_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_get_value_function (ValaCodeNode* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (sym);
	_tmp1_ = vala_ccode_attribute_get_get_value_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_set_value_function (ValaCodeNode* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (sym);
	_tmp1_ = vala_ccode_attribute_get_set_value_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_take_value_function (ValaCodeNode* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (sym);
	_tmp1_ = vala_ccode_attribute_get_take_value_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_param_spec_function (ValaCodeNode* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (sym);
	_tmp1_ = vala_ccode_attribute_get_param_spec_function (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_type_check_function (ValaTypeSymbol* sym)
{
	ValaClass* cl = NULL;
	gchar* a = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaClass* _tmp2_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	cl = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS) ? ((ValaClass*) sym) : NULL;
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "type_check_function", NULL);
	a = _tmp0_;
	_tmp2_ = cl;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = a;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = a;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		ValaClass* _tmp8_;
		_tmp8_ = cl;
		if (_tmp8_ != NULL) {
			ValaClass* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp9_ = cl;
			_tmp10_ = vala_class_get_is_compact (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp7_ = _tmp11_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT);
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM);
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE);
		}
		if (_tmp4_) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("");
			result = _tmp12_;
			_g_free0 (a);
			return result;
		} else {
			gchar* _tmp13_;
			_tmp13_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sym, "IS_");
			result = _tmp13_;
			_g_free0 (a);
			return result;
		}
	}
}

gchar*
vala_get_ccode_class_type_check_function (ValaClass* cl)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (cl != NULL, NULL);
	_tmp0_ = vala_class_get_is_compact (cl);
	_tmp1_ = _tmp0_;
	_vala_assert (!_tmp1_, "!cl.is_compact");
	_tmp2_ = vala_get_ccode_type_check_function ((ValaTypeSymbol*) cl);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s_CLASS", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

gchar*
vala_get_ccode_default_value (ValaTypeSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_default_value (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_default_value_on_error (ValaTypeSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_default_value_on_error (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
vala_get_ccode_has_copy_function (ValaStruct* st)
{
	gboolean result;
	g_return_val_if_fail (st != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) st, "CCode", "has_copy_function", TRUE);
	return result;
}

gboolean
vala_get_ccode_has_destroy_function (ValaStruct* st)
{
	gboolean result;
	g_return_val_if_fail (st != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) st, "CCode", "has_destroy_function", TRUE);
	return result;
}

gdouble
vala_get_ccode_instance_pos (ValaCodeNode* node)
{
	gdouble result;
	g_return_val_if_fail (node != NULL, 0.0);
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_DELEGATE)) {
		result = vala_code_node_get_attribute_double (node, "CCode", "instance_pos", (gdouble) -2);
		return result;
	} else {
		result = vala_code_node_get_attribute_double (node, "CCode", "instance_pos", (gdouble) 0);
		return result;
	}
}

gdouble
vala_get_ccode_error_pos (ValaCallable* c)
{
	gdouble result;
	g_return_val_if_fail (c != NULL, 0.0);
	result = vala_code_node_get_attribute_double ((ValaCodeNode*) c, "CCode", "error_pos", (gdouble) -1);
	return result;
}

gboolean
vala_get_ccode_array_length (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_array_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gchar*
vala_get_ccode_array_length_type (ValaCodeNode* node)
{
	gchar* result;
	g_return_val_if_fail (node != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_ARRAY_TYPE)) {
		ValaDataType* _tmp0_;
		ValaDataType* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = vala_array_type_get_length_type (G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1_);
		result = _tmp2_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_DATA_TYPE)) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_code_node_get_source_reference (node);
			_tmp4_ = _tmp3_;
			vala_report_error (_tmp4_, "`CCode.array_length_type' not supported");
			_tmp5_ = g_strdup ("");
			result = _tmp5_;
			return result;
		} else {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			ValaCCodeAttribute* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_METHOD)) {
				_tmp9_ = TRUE;
			} else {
				_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_PARAMETER);
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_DELEGATE);
			}
			if (_tmp8_) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_PROPERTY);
			}
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_FIELD);
			}
			_vala_assert (_tmp6_, "node is Method || node is Parameter || node is Delegate || node is Property || node is Field");
			_tmp10_ = vala_get_ccode_attribute (node);
			_tmp11_ = vala_ccode_attribute_get_array_length_type (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
	}
}

gboolean
vala_get_ccode_array_null_terminated (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_array_null_terminated (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gchar*
vala_get_ccode_array_length_name (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_array_length_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_array_length_expr (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_array_length_expr (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

gdouble
vala_get_ccode_array_length_pos (ValaCodeNode* node)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaAttribute* _tmp3_;
	gdouble result;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = vala_code_node_get_attribute (node, "CCode");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	a = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ValaAttribute* _tmp4_;
		_tmp4_ = a;
		_tmp2_ = vala_attribute_has_argument (_tmp4_, "array_length_pos");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaAttribute* _tmp5_;
		_tmp5_ = a;
		result = vala_attribute_get_double (_tmp5_, "array_length_pos", (gdouble) 0);
		_vala_code_node_unref0 (a);
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaParameter* _tmp6_;
		param = G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_PARAMETER, ValaParameter);
		_tmp6_ = param;
		result = vala_get_ccode_pos (_tmp6_) + 0.1;
		_vala_code_node_unref0 (a);
		return result;
	} else {
		result = (gdouble) -3;
		_vala_code_node_unref0 (a);
		return result;
	}
}

gdouble
vala_get_ccode_delegate_target_pos (ValaCodeNode* node)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaAttribute* _tmp3_;
	gdouble result;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = vala_code_node_get_attribute (node, "CCode");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	a = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ValaAttribute* _tmp4_;
		_tmp4_ = a;
		_tmp2_ = vala_attribute_has_argument (_tmp4_, "delegate_target_pos");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaAttribute* _tmp5_;
		_tmp5_ = a;
		result = vala_attribute_get_double (_tmp5_, "delegate_target_pos", (gdouble) 0);
		_vala_code_node_unref0 (a);
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaParameter* _tmp6_;
		param = G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_PARAMETER, ValaParameter);
		_tmp6_ = param;
		result = vala_get_ccode_pos (_tmp6_) + 0.1;
		_vala_code_node_unref0 (a);
		return result;
	} else {
		result = (gdouble) -3;
		_vala_code_node_unref0 (a);
		return result;
	}
}

gdouble
vala_get_ccode_destroy_notify_pos (ValaCodeNode* node)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaAttribute* _tmp3_;
	gdouble result;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = vala_code_node_get_attribute (node, "CCode");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	a = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ValaAttribute* _tmp4_;
		_tmp4_ = a;
		_tmp2_ = vala_attribute_has_argument (_tmp4_, "destroy_notify_pos");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaAttribute* _tmp5_;
		_tmp5_ = a;
		result = vala_attribute_get_double (_tmp5_, "destroy_notify_pos", (gdouble) 0);
		_vala_code_node_unref0 (a);
		return result;
	}
	result = vala_get_ccode_delegate_target_pos (node) + 0.01;
	_vala_code_node_unref0 (a);
	return result;
}

gboolean
vala_get_ccode_delegate_target (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_delegate_target (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gchar*
vala_get_ccode_delegate_target_name (ValaVariable* variable)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (variable != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) variable);
	_tmp1_ = vala_ccode_attribute_get_delegate_target_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_delegate_target_destroy_notify_name (ValaVariable* variable)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (variable != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) variable);
	_tmp1_ = vala_ccode_attribute_get_delegate_target_destroy_notify_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gdouble
vala_get_ccode_pos (ValaParameter* param)
{
	ValaCCodeAttribute* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble result;
	g_return_val_if_fail (param != NULL, 0.0);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) param);
	_tmp1_ = vala_ccode_attribute_get_pos (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gchar*
vala_get_ccode_type (ValaCodeNode* node)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = vala_ccode_attribute_get_ctype (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
vala_get_ccode_simple_generics (ValaMethod* m)
{
	gboolean result;
	g_return_val_if_fail (m != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "CCode", "simple_generics", FALSE);
	return result;
}

gchar*
vala_get_ccode_real_name (ValaSymbol* sym)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = vala_ccode_attribute_get_real_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
vala_get_ccode_constructv_name (ValaCreationMethod* m)
{
	static const char infix[] = "constructv";
	ValaClass* parent = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp1_ = _tmp0_;
	parent = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass);
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, ".new") == 0) {
		ValaClass* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = parent;
		_tmp5_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("%s%s", _tmp6_, infix);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		result = _tmp8_;
		return result;
	} else {
		ValaClass* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp9_ = parent;
		_tmp10_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("%s%s_%s", _tmp11_, infix, _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp11_);
		result = _tmp15_;
		return result;
	}
}

gchar*
vala_get_ccode_vfunc_name (ValaMethod* m)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp1_ = vala_ccode_attribute_get_vfunc_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gdouble
vala_get_ccode_async_result_pos (ValaMethod* m)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gdouble result;
	g_return_val_if_fail (m != NULL, 0.0);
	_tmp0_ = vala_method_get_coroutine (m);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_, "m.coroutine");
	result = vala_code_node_get_attribute_double ((ValaCodeNode*) m, "CCode", "async_result_pos", 0.1);
	return result;
}

gchar*
vala_get_ccode_finish_name (ValaMethod* m)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_method_get_coroutine (m);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_, "m.coroutine");
	_tmp2_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp3_ = vala_ccode_attribute_get_finish_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}

gchar*
vala_get_ccode_finish_vfunc_name (ValaMethod* m)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_method_get_coroutine (m);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_, "m.coroutine");
	_tmp2_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp3_ = vala_ccode_attribute_get_finish_vfunc_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}

gchar*
vala_get_ccode_finish_real_name (ValaMethod* m)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCCodeAttribute* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_method_get_coroutine (m);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_, "m.coroutine");
	_tmp2_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp3_ = vala_ccode_attribute_get_finish_real_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}

gboolean
vala_get_ccode_no_accessor_method (ValaProperty* p)
{
	ValaAttribute* _tmp0_;
	gboolean result;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) p, "NoAccessorMethod");
	result = _tmp0_ != NULL;
	return result;
}

gboolean
vala_get_ccode_concrete_accessor (ValaProperty* p)
{
	ValaAttribute* _tmp0_;
	gboolean result;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) p, "ConcreteAccessor");
	result = _tmp0_ != NULL;
	return result;
}

gboolean
vala_get_ccode_has_emitter (ValaSignal* sig)
{
	ValaAttribute* _tmp0_;
	gboolean result;
	g_return_val_if_fail (sig != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) sig, "HasEmitter");
	result = _tmp0_ != NULL;
	return result;
}

gboolean
vala_get_ccode_has_type_id (ValaTypeSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (sym != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) sym);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = vala_code_node_get_attribute_bool ((ValaCodeNode*) sym, "CCode", "has_type_id", FALSE);
		return result;
	} else {
		result = vala_code_node_get_attribute_bool ((ValaCodeNode*) sym, "CCode", "has_type_id", TRUE);
		return result;
	}
}

gboolean
vala_get_ccode_has_new_function (ValaMethod* m)
{
	gboolean result;
	g_return_val_if_fail (m != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "CCode", "has_new_function", TRUE);
	return result;
}

gboolean
vala_get_ccode_has_generic_type_parameter (ValaMethod* m)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaAttribute* _tmp3_;
	gboolean result;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) m, "CCode");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	a = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_ != NULL) {
		ValaAttribute* _tmp4_;
		_tmp4_ = a;
		_tmp2_ = vala_attribute_has_argument (_tmp4_, "generic_type_pos");
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_vala_code_node_unref0 (a);
	return result;
}

gdouble
vala_get_ccode_generic_type_pos (ValaMethod* m)
{
	gdouble result;
	g_return_val_if_fail (m != NULL, 0.0);
	result = vala_code_node_get_attribute_double ((ValaCodeNode*) m, "CCode", "generic_type_pos", (gdouble) 0);
	return result;
}

gboolean
vala_get_ccode_no_wrapper (ValaMethod* m)
{
	ValaAttribute* _tmp0_;
	gboolean result;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) m, "NoWrapper");
	result = _tmp0_ != NULL;
	return result;
}

gchar*
vala_get_ccode_sentinel (ValaMethod* m)
{
	ValaCCodeAttribute* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp1_ = vala_ccode_attribute_get_sentinel (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

