/*
 * Broadcom oops capture and display (boops)
 *
 * Copyright (C) 2017 Broadcom
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef BOOPS_K_STORAGE_H
#define BOOPS_K_STORAGE_H

struct boops_storage_t {
    /* Called to write 'block_count' blocks of oops dump data to the storge device starting */
    int (*write_blocks)(const struct boops_storage_t *storage, uint8_t *buf, uint32_t block_count);

    /* Called when the storage device is no longer necessary */
    void (*destroy)(struct boops_storage_t *storage);

    struct {
        uint32_t bytes;                                                 /* The size (in bytes) of each writable block */
        size_t count;                                                   /* The number of writable blocks */
    } block;
};

#ifdef CONFIG_MMC
struct boops_storage_t* boops_storage_mmc_create(const uint32_t block_first, const uint32_t block_count);
#endif

#ifdef CONFIG_MTD_UBI
struct boops_storage_t* boops_storage_ubi_create(const uint32_t ubi_device, const uint32_t ubi_volume);
#endif

#endif //BOOPS_K_STORAGE_H
