/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * Copyright (c) 2019 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Paul Tweedale <paul.tweedale@broadcom.com>
 ***************************************************************************/

#ifndef __BCMFLOWMAP_H
#define __BCMFLOWMAP_H

#include "bcmflow.h"

#define	BCMFLOW_MAPT			0	/* MAP-T transport mode */

#define BCMFLOW_MAP_CONFIG(dev, p)					\
	flowmgr_map_config(dev, p);

#define BCMFLOW_MAP_FLUSH(d)						\
	flowmgr_map_flush(d);

#define BCMFLOW_MAP_4TO6_ENTRY(s)					\
	__u32 bcmflow_map_addr;						\
	__u16 bcmflow_map_port;						\
	int bcmflow_map_ret;						\
	bcmflow_map_ret = flowmgr_map_get_src(s,			\
					      &bcmflow_map_addr,	\
					      &bcmflow_map_port);	\
	flowmgr_map_add(s, NULL, -1, 0, 0);


#define BCMFLOW_MAP_4TO6_EXIT(s, n, d)					\
	flowmgr_map_add(s, n, d, bcmflow_map_addr, bcmflow_map_port);

#define BCMFLOW_MAP_6TO4_ENTRY(s)					\
	flowmgr_map_add(s, NULL, -1, 0, 0);

#define BCMFLOW_MAP_6TO4_EXIT(s, n, d)					\
	flowmgr_map_add(s, n, d, 0, 0);

extern int flowmgr_map_config(struct net_device *dev,
			      struct flow_map_params *params);

/*
With cernet driver,
In 4to6 direction, skb is the after NAT44 MAPv4 packet, newskb is the MAPv6 packet
In 6to4 direction, skb is the MAPv6 packet, newskb is the IPv4 packet

With nat46 driver,
In 4to6 direction, skb is the after NAT44 MAPv4 packet, newskb is the MAPv6 packet
In 6to4 direction, skb is the MAPv6 packet, newskb is the MAPv4 packet (before undoing SNAT)

lan_addr and lan_port is used for setting the LAN CPE addr/port.
*/
extern int flowmgr_map_add(struct sk_buff *skb,
			   struct sk_buff *newskb,
			   int domain,
			   __u32 lan_addr,
			   __u16 lan_port);

extern int flowmgr_map_flush(int domain);

extern int flowmgr_map_get_src(struct sk_buff *skb,
			       __u32 *addr, __u16 *port);
extern int flowmgr_map_set_src(struct sk_buff *skb,
			       __u32 addr, __u16 port);

#endif
