 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#define LEAP_CTRL_ADDR_TRANS(x) (x + 0xAC)
#define LEAP_CTRL_BYTE_SWAP_EN(x) (x + 0xA8)

#define CPU_COMM_REGS_CPUC_AP_LOST_MAJOR_DELAY(x) (x + 0x10)
#define AP_LOST_DELAY_CNT_SHIFT 0
#define AP_LOST_DELAY_CNT_MASK 0x7FFFFF

#define CM_TOP_CTRL_SW_INIT_0_SET (info->cm_top + 0x318)
#define CM_TOP_CTRL_SW_INIT_0_CLEAR (info->cm_top + 0x31c)
#define CM_TOP_CTRL_SW_INIT_0_STATUS (info->cm_top + 0x320)
#define CM_TOP_CTRL_PIN_MUX_CTRL_0 (info->cm_top + 0x100)
#define CM_TOP_CTRL_PIN_MUX_CTRL_1 (info->cm_top + 0x104)
#define EXT_SYS_SW_INIT_MASK 1
#define EXT_SYS_SW_INIT_SHIFT 2
#define CPU_SW_INIT_MASK 1
#define CPU_SW_INIT_SHIFT 1
#define CM_SYS_CTRL_SW_INIT_MASK 1
#define CM_SYS_CTRL_SW_INIT_SHIFT 0

#define AON_CTRL_PM_CTRL (info->aon + 0x4)
#define REBOOT_ON_POWERLOSS_MASK 1
#define REBOOT_ON_POWERLOSS_SHIFT 18
#define PM_SET_FORCE_BATTERY_MODE_MASK 1
#define PM_SET_FORCE_BATTERY_MODE_SHIFT 13
#define PM_SET_AUTO_BATTERY_MODE_RULES_MASK 1
#define PM_SET_AUTO_BATTERY_MODE_RULES_SHIFT 12

#define AON_CTRL_UNCLEARED_SCRATCH (info->aon + 0x68)
#define PARK_ON_REBOOT_MASK 1
#define PARK_ON_REBOOT_SHIFT 0

#define AON_PM_BBM_L2_CPU_STATUS (info->aon + 0x680)
#define AON_PM_BBM_L2_CPU_CLEAR (info->aon + 0x688)
#define DCS_HEADEND_INTR_MASK 1
#define DCS_HEADEND_INTR_SHIFT 19
#define BMU_INTR_AP_RESTORED_MASK 1
#define BMU_INTR_AP_RESTORED_SHIFT 17

#define MC_ATW_OFFSET 0xC00
#define MC_ATW(base) (base + MC_ATW_OFFSET)
#define MC_ATW_ENABLE(base) MC_ATW(base)
#define ATW_ENABLE_MASK 1
#define ATW_ENABLE_SHIFT 0

#define MC_ATW_SOURCE_START_ADDRESS(base) (MC_ATW(base) + 0x20)
#define MC_ATW_SIZE_MASK(base) (MC_ATW(base) + 0x40)
#define MC_ATW_DESTINATION_START_ADDRESS(base) (MC_ATW(base) + 0x60)
#define MC_ATW_CLIENTS_MATCH_UBUS_31_0(base) (MC_ATW(base) + 0x80)
#define MC_ATW_CLIENTS_MATCH_UBUS_95_64(base) (MC_ATW(base) + 0xc0)
#define MC_ATW_CLIENTS_MATCH_UBUS_159_128(base) (MC_ATW(base) + 0x100)
#define MC_ATW_CLIENTS_MATCH_UBUS_223_192(base) (MC_ATW(base) + 0x140)

#define ATW_IDX(idx) (idx * 0x4)

#define ARC_SUPPORT /* 3390 SW will support ARC */

/* MEMC - SCB */
#define SCB_IDX(idx) (idx * 0x6C)

#define MC_SCB_NONSEC_OFFSET 0x1c00
#define SCB_NONSEC(base) (base + MC_SCB_NONSEC_OFFSET)

#define SCB_ARC_CNTRL(base, idx) (SCB_NONSEC(base) + SCB_IDX(idx))
#define SCB_CNTRL_WRITE_ABT_MASK 0x10
#define SCB_CNTRL_WRITE_ABT_SHIFT 4
#define SCB_CNTRL_WRITE_CHK_MASK 0x8
#define SCB_CNTRL_WRITE_CHK_SHIFT 3
#define SCB_CNTRL_READ_ABT_MASK 0x4
#define SCB_CNTRL_READ_ABT_SHIFT 2
#define SCB_CNTRL_READ_CHK_MASK 0x2
#define SCB_CNTRL_READ_CHK_SHIFT 1
#define SCB_CNTRL_MODE_MASK 0x1
#define SCB_CNTRL_MODE_SHIFT 0

#define SCB_ARC_LOW(base, idx) (SCB_NONSEC(base) + SCB_IDX(idx) + 0x4)
#define SCB_ARC_HIGH(base, idx) (SCB_NONSEC(base) + SCB_IDX(idx) + 0xC)
#define SCB_RR_IDX(x) (0x14 + (0x4 * x))
#define SCB_WR_IDX(x) (0x34 + (0x4 * x))
#define SCB_RR(base, idx, x) (SCB_NONSEC(base) + SCB_IDX(idx) + SCB_RR_IDX(x))
#define SCB_WR(base, idx, x) (SCB_NONSEC(base) + SCB_IDX(idx) + SCB_WR_IDX(x))
#define SCB_VIOLATION_START(base, idx) (SCB_NONSEC(base) + SCB_IDX(idx) + 0x54)
#define SCB_VIOLATION_END(base, idx) (SCB_NONSEC(base) + SCB_IDX(idx) + 0x5C)

#define SCB_VIOLATION_CMD(base, idx) (SCB_NONSEC(base) + SCB_IDX(idx) + 0x64)
#define SCB_VIOLATION_CMD_CLIENTID_MASK 0xFF000000
#define SCB_VIOLATION_CMD_CLIENTID_SHIFT 24
#define SCB_VIOLATION_CMD_NMB_MASK 0x3FF000
#define SCB_VIOLATION_CMD_NMB_SHIFT 12
#define SCB_VIOLATION_CMD_TYPE_MASK 0x1FF
#define SCB_VIOLATION_CMD_TYPE_SHIFT 0

#define SCB_VIOLATION_CLEAR(base, idx) (SCB_NONSEC(base) + SCB_IDX(idx) + 0x68)

/* MEMC - UBUS */
#define UBUS_NONSEC_OFFSET 0x1800
#define UBUS_NONSEC(base) (base + UBUS_NONSEC_OFFSET)

#define UBUS_ARC_CNTRL(base, idx) (UBUS_NONSEC(base) + (idx * 0x4))
#define UBUS_CNTRL_MODE_MASK 0x1
#define UBUS_CNTRL_MODE_SHIFT 0
#define UBUS_ARC_LOW(base, idx) (UBUS_NONSEC(base) + (idx * 0x4) + 0x20)
#define UBUS_ARC_HIGH(base, idx) (UBUS_NONSEC(base) + (idx * 0x4) + 0x60)
#define UBUS_RR(base, idx, x) (UBUS_NONSEC(base) + (idx * 0x4) + 0xA0 + \
			       (0x20 * x))
#define UBUS_WR(base, idx, x) (UBUS_NONSEC(base) + (idx * 0x4) + 0x1A0 + \
			       (0x20 * x))
#define UBUS_VIOLATION_CMD(base, idx) (UBUS_NONSEC(base) + (idx * 0x4) + 0x2A0)
#define UBUS_VIOLATION_START(base, idx) (UBUS_NONSEC(base) + (idx * 0x4) + \
					 0x2C0)
#define UBUS_VIOLATION_END(base, idx) (UBUS_NONSEC(base) + (idx * 0x4) + 0x300)
#define UBUS_VIOLATION_CLEAR(base, idx) (UBUS_NONSEC(base) + (idx * 0x4) + \
					 0x340)
#define UBUS_VIOLATION_CMD_SRC_MASK 0xFF000000
#define UBUS_VIOLATION_CMD_SRC_SHIFT 24
#define UBUS_VIOLATION_CMD_PKT_MASK 0x3FF000
#define UBUS_VIOLATION_CMD_PKT_SHIFT 12
#define UBUS_VIOLATION_CMD_TYPE_MASK 0x1FF
#define UBUS_VIOLATION_CMD_TYPE_SHIFT 0

/* MEMC - INTR */
#define MC_INTR2_OFFSET 0x80
#define MC_INTR2(base) (base + MC_INTR2_OFFSET)
#define MC_INTR2_STATUS(base) MC_INTR2(base)
#define MC_INTR2_CLEAR(base) (MC_INTR2(base) + 0x8)
#define MC_INTR2_MASK_SET(base) (MC_INTR2(base) + 0x10)
#define MC_INTR2_MASK_CLEAR(base) (MC_INTR2(base) + 0x14)
#define MC_INTR2_MASK_VALUE 0x1

#define MC_SEC_INTR2_OFFSET 0xE00
#define MC_SEC_INTR2(base) (base + MC_SEC_INTR2_OFFSET)
#define MC_SEC_INTR2_STATUS(base) MC_SEC_INTR2(base)
#define MC_SEC_INTR2_CLEAR(base) (MC_SEC_INTR2(base) + 0x8)
#define MC_SEC_INTR2_MASK_SET(base) (MC_SEC_INTR2(base) + 0x10)
#define MC_SEC_INTR2_MASK_CLEAR(base) (MC_SEC_INTR2(base) + 0x14)
#define MC_SEC_INTR2_MASK_VALUE 0x5

#define MC_INT_ENABLE(base) \
	do { \
		W32(MC_SEC_INTR2_MASK_CLEAR(base), MC_SEC_INTR2_MASK_VALUE); \
		W32(MC_INTR2_MASK_CLEAR(base), MC_INTR2_MASK_VALUE); \
	} while (0)

#define MC_INT_DISABLE(base) \
	do { \
		W32(MC_SEC_INTR2_MASK_SET(base), MC_SEC_INTR2_MASK_VALUE); \
		W32(MC_INTR2_MASK_SET(base), MC_INTR2_MASK_VALUE); \
	} while (0)

#define MC_INT_CLEAR(base) \
	do { W32(MC_SEC_INTR2_CLEAR(base), MC_SEC_INTR2_MASK_VALUE); \
		W32(MC_INTR2_CLEAR(base), MC_INTR2_MASK_VALUE); \
	} while (0)

#define ARC_DT_FIELD_COUNT 22

/* Unfortunately ARC is pretty chip specific... */
/* Add some macro's here to abstract */
#define ARC_CNTRL(var, enable, exclusive) \
do {\
	if (!enable) \
		var = 0; \
	else \
		if (exclusive) \
			var = 0x1F; \
		else \
			var = 0x1E; \
} while (0)

#define ARC_UBUS(base, idx, arc, i, cntrl) \
do { \
	W32(UBUS_ARC_LOW(base, idx), ((u32)arc->start)>>3); \
	W32(UBUS_ARC_HIGH(base, idx), ((u32)arc->end)>>3); \
	for (i = 0; i < MAX_ARC; i++) \
		W32(UBUS_RR(base, idx, i), arc->read[i]); \
	for (i = 0; i < MAX_ARC; i++) \
		W32(UBUS_WR(base, idx, i), arc->write[i]); \
	W32(UBUS_ARC_CNTRL(base, idx), cntrl); \
} while (0)

#define ARC_SCB(base, idx, arc, i, cntrl) \
do { \
	W32(SCB_ARC_LOW(base, idx), ((u32)arc->start)>>3); \
	W32(SCB_ARC_HIGH(base, idx), ((u32)arc->end)>>3); \
	for (i = 0; i < MAX_ARC; i++) \
		W32(SCB_RR(base, idx, i), arc->read[i]); \
	for (i = 0; i < MAX_ARC; i++) \
		W32(SCB_WR(base, idx, i), arc->write[i]); \
	W32(SCB_ARC_CNTRL(base, idx), cntrl); \
} while (0)

#define ARC_UBUS_GET_CNTRL(var, idx) R32(var, UBUS_ARC_CNTRL(idx))
#define ARC_SCB_GET_CNTRL(var, idx) R32(var, SCB_ARC_CNTRL(idx))

#define ARC_INTEREST(status) (status & 0x1)
