/****************************************************************************
 *
 * Copyright (c) 2023 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef BP3_FEAT_MAP_H
#define BP3_FEAT_MAP_H

/*
 * Specifies the feature list or extended bit map group.
 * It indicates the bit map in which the feature lies.
 */
#define BP3_V2_FEAT_LIST_MAP					0
#define BP3_V3_EXT_FEAT_GRP_ADV_BRIDGING_MAP	1
#define BP3_V3_EXT_FEAT_GRP_ADV_VOICE_MAP		2
#define BP3_V3_EXT_FEAT_GRP_BATT_THERM_MAP		11

/*
 * This enum specifies the index of the decode table to be used
 * to decode the feature's field bits to a real-world value. Only
 * multi-bit fields that actually need decoding should be created.
 */
#define	BP3_FEAT_DEC_TBL_MAX_CPU_FREQ		0
#define BP3_FEAT_DEC_TBL_MAX_DS_MOD_MODE	1

/*
 * The values for each feature enum are encoded such that they easily identify
 * where to find the feature bits in the license and how to interpret
 * them.
 */
#define FEAT_MAP_SHIFT		(0)
#define FEAT_MAP_MASK		(0x1ff)	/* max 512 feature maps */
#define FEAT_POS_SHIFT		(9)
#define FEAT_POS_MASK		(0xff)	/* max 256b/map */
#define FEAT_SIZE_SHIFT		(17)
#define FEAT_SIZE_MASK		(0x1f)	/* max 32b/feat */
#define FEAT_DEC_TBL_SHIFT	(22)
#define FEAT_DEC_TBL_MASK	(0x3ff)	/* max 1024 field value decode tables */

#define ENC_FEAT(map, POS, num, ttbl) \
	((((map) & FEAT_MAP_MASK) << FEAT_MAP_SHIFT) | \
	 (((POS) & FEAT_POS_MASK) << FEAT_POS_SHIFT) | \
	 (((num) & FEAT_SIZE_MASK) << FEAT_SIZE_SHIFT) | \
	 (((ttbl) & FEAT_DEC_TBL_MASK) << FEAT_DEC_TBL_SHIFT))
#define FEAT_MAP(x) \
	(((x) >> FEAT_MAP_SHIFT) & FEAT_MAP_MASK)
#define FEAT_POS(x) \
	(((x) >> FEAT_POS_SHIFT) & FEAT_POS_MASK)
#define FEAT_SIZE(x) \
	(((x) >> FEAT_SIZE_SHIFT) & FEAT_SIZE_MASK)
#define FEAT_DEC_TBL(x) \
	(((x) >> FEAT_DEC_TBL_SHIFT) & FEAT_DEC_TBL_MASK)
#define FEAT_RTN_MASK(x) ((1 << FEAT_SIZE(x)) - 1)
#define FEAT_RTN_VAL(x) ((1 << FEAT_SIZE(x)) - 1)

/*
 * Feature Defines
 * To make feature value extraction simple, the enum values are chosen by
 * encoding the details of where to find the feature in the various feature
 * bit maps in the license file. To do this we encode the feature list/extended
 * feature group bit map, the starting bit position, the number of bits,
 * and an index to a decode table to be used if the feature field is multiple
 * bits and needs decoding to a real-world value.
 */
#define BP3_FEAT_EMMC			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 13, 1, -1)
#define BP3_FEAT_MERLIN			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 14, 1, -1)
#define BP3_FEAT_RGMII0			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 18, 1, -1)
#define BP3_FEAT_RGMII1			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 19, 1, -1)
#define BP3_FEAT_XLMAC0			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 20, 3, -1)
#define BP3_FEAT_XLMAC1			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 23, 3, -1)
#define BP3_FEAT_XLMAC2			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 26, 3, -1)
#define BP3_FEAT_XLMAC3			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 29, 3, -1)

/* Max # CPU cores is multi-bit field but does not need decoding */
#define BP3_FEAT_MAX_NUM_CPU	ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 32, 4, -1)

#define BP3_FEAT_PCIE0			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 42, 1, -1)
#define BP3_FEAT_PCIE1			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 43, 1, -1)
#define BP3_FEAT_PCIE2			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 44, 1, -1)
#define BP3_FEAT_PCIE3			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 45, 1, -1)
#define BP3_FEAT_USB			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 46, 1, -1)
#define BP3_FEAT_UNIMAC0		ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 48, 1, -1)
#define BP3_FEAT_UNIMAC1		ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 49, 1, -1)
#define BP3_FEAT_GPHY0			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 50, 1, -1)
#define BP3_FEAT_GPHY1			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 51, 1, -1)
#define BP3_FEAT_CRYPTO2		ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 96, 1, -1)
#define BP3_FEAT_SPU			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 98, 1, -1)
#define BP3_FEAT_BSTM			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 104, 1, -1)
#define BP3_FEAT_V3D			ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 105, 1, -1)

#define BP3_FEAT_MAX_CPU_FREQ		ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 36, 4, BP3_FEAT_DEC_TBL_MAX_CPU_FREQ),
#define BP3_FEAT_MAX_DS_MOD_MODE	ENC_FEAT(BP3_V2_FEAT_LIST_MAP, 156, 4, BP3_FEAT_DEC_TBL_MAX_DS_MOD_MODE),
#define BP3_FEAT_THERMAL_THROTTLING	ENC_FEAT(BP3_V3_EXT_FEAT_GRP_BATT_THERM_MAP, 2, 1, -1),

#endif