/*
 * Copyright (C) 2019 Broadcom Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifdef CONFIG_BCM_KF_CM

#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <asm/types.h>
#include <linux/seq_file.h>
#include "sram_dump_priv.h"

#define	BRCM_SRAM_DUMP_PROC_DIR		"driver/sramdump"
#define	BRCM_SRAM_DUMP_PROC_CLEAR	"driver/sramdump/clear"
#define	BRCM_SRAM_DUMP_PROC_SHOW_PREV	"driver/sramdump/show_prev"
#define	BRCM_SRAM_DUMP_PROC_SHOW_NOW	"driver/sramdump/show_now"


static ssize_t brcm_sram_dump_proc_clear(struct file *filp,
	const char __user *user_buf, size_t count, loff_t *pos)
{
	brcm_sram_dump_clear_priv();

	return count;
}

static int brcm_sram_dump_proc_show_prev(struct seq_file *s, void *data)
{
	return brcm_sram_dump_show_prev_priv(s);
}

static int brcm_sram_dump_proc_show_now(struct seq_file *s, void *data)
{
	return brcm_sram_dump_show_now_priv(s);
}

static int brcm_sram_dump_proc_show_prev_open(struct inode *inode,
	struct file *filp)
{
    return single_open(filp, &brcm_sram_dump_proc_show_prev, NULL);
}

static int brcm_sram_dump_proc_show_now_open(struct inode *inode,
	struct file *filp)
{
    return single_open(filp, &brcm_sram_dump_proc_show_now, NULL);
}

static struct proc_ops brcm_sram_dump_proc_clear_fops = {
	.proc_write = brcm_sram_dump_proc_clear,
};

static struct proc_ops brcm_sram_dump_proc_show_prev_fops = {
	.proc_open = brcm_sram_dump_proc_show_prev_open,
	.proc_read = seq_read,
	.proc_release = single_release,
};

static struct proc_ops brcm_sram_dump_proc_show_now_fops = {
	.proc_open = brcm_sram_dump_proc_show_now_open,
	.proc_read = seq_read,
	.proc_release = single_release,
};

int brcm_sram_dump_proc_init (void)
{
	/* Create proc entry */
	if (!proc_mkdir(BRCM_SRAM_DUMP_PROC_DIR, NULL)) {
		pr_err("brcm_sram_dump_proc_init: failed to create %s dir\n",
			BRCM_SRAM_DUMP_PROC_DIR);
		return -ENOMEM;
	}
	if (!proc_create(BRCM_SRAM_DUMP_PROC_CLEAR, 0644, NULL,
		&brcm_sram_dump_proc_clear_fops)) {
		pr_err("brcm_sram_dump_proc_init: failed to create %s\n",
			BRCM_SRAM_DUMP_PROC_CLEAR);
		return -ENOMEM;
	}

	if (!proc_create(BRCM_SRAM_DUMP_PROC_SHOW_PREV, 0444, NULL,
		&brcm_sram_dump_proc_show_prev_fops)) {
		pr_err("brcm_sram_dump_proc_init: failed to create %s\n",
			BRCM_SRAM_DUMP_PROC_SHOW_PREV);
		return -ENOMEM;
	}

	if (!proc_create(BRCM_SRAM_DUMP_PROC_SHOW_NOW, 0444, NULL,
		&brcm_sram_dump_proc_show_now_fops)) {
		pr_err("brcm_sram_dump_proc_init: failed to create %s\n",
			BRCM_SRAM_DUMP_PROC_SHOW_NOW);
		return -ENOMEM;
	}

	return 0;
}

void brcm_sram_dump_proc_exit(void)
{
	remove_proc_entry(BRCM_SRAM_DUMP_PROC_CLEAR, NULL);
	remove_proc_entry(BRCM_SRAM_DUMP_PROC_SHOW_PREV, NULL);
	remove_proc_entry(BRCM_SRAM_DUMP_PROC_SHOW_NOW, NULL);
	remove_proc_entry(BRCM_SRAM_DUMP_PROC_DIR, NULL);
}

#endif /* CONFIG_BCM_KF_CM */
