/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/

#ifndef _DQNET_NETHOOKS_H_
#define _DQNET_NETHOOKS_H_

#include <bcmnethooks.h>

#define DQNET_DROP_SWITCH_TO_SWITCH_NAME \
	"DQNet Drop Switch Port to Switch Port"
enum bcm_nethook_result dqnet_drop_switch_to_switch_hook(
	struct net_device *dev, enum bcm_nethook_type type, void *buf);

#define DQNET_SWITCH_REDUNDANT_MCAST_NAME \
	"DQNet Drop Redundant Switch Broad/Multicasts"
enum bcm_nethook_result dqnet_drop_redundant_switch_mcasts_hook(
	struct net_device *dev, enum bcm_nethook_type type, void *buf);

#define DQNET_TAG_SWITCH_MCASTS_NAME	"DQNet Tag Switch Broad/Multicasts"
enum bcm_nethook_result dqnet_tag_switch_mcasts_hook(
	struct net_device *dev, enum bcm_nethook_type type, void *buf);

#define DQNET_ETH_CLIENT_RETRANSMIT_NAME \
	"DQNet Retransmit Ethernet client to source"
enum bcm_nethook_result dqnet_eth_client_retrans_source_hook(
	struct net_device *dev, enum bcm_nethook_type type, void *buf);

#define DQNET_WMF_NAME \
	"DQNet WLAN Multicast Forwarding"
enum bcm_nethook_result dqnet_tx_skb_wlan_hook(
	struct net_device *dev, enum bcm_nethook_type type, void *buf);

#define DQNET_DROP_PRIV_NAME \
	"DQNet Drop Priv"
enum bcm_nethook_result dqnet_rx_drop_priv_hook(
	struct net_device *dev, enum bcm_nethook_type type, void *buf);
enum bcm_nethook_result dqnet_tx_drop_priv_hook(
	struct net_device *dev, enum bcm_nethook_type type, void *buf);
enum bcm_nethook_result dqnet_tx_drop_priv_cm_hook(
	struct net_device *dev, enum bcm_nethook_type type, void *buf);

#endif
