/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2023 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Peter Sulc <peter.sulc@broadcom.com>
 *****************************************************************************/

#include <linux/types.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/io.h>
#include <linux/bitops.h>
#include <linux/compiler.h>

#include "dqm.h"
#include "dqm_dev.h"
#include "dqm_hw.h"


int dqm_generic_rx(struct dqm *q, int messages, u32 *data)
{
	int i, j;
	int n = q->msg_size;

	for (i = 0; i < messages; i++) {
		u32 *reg = q->data;
		for (j = 0; j < n; j++) {
			*data++ = dqm_reg_read(reg++);
		}
	}
	return messages;
}

void __weak dqm_set_rx(struct dqm *q)
{
	q->rx = dqm_generic_rx;
}

int dqm_generic_tx(struct dqm *q, int messages, u32 *data)
{
	int i, j;
	int n = q->msg_size;

	for (i = 0; i < messages; i++) {
		u32 *reg = q->data;
		for (j = 0; j < n; j++)
			dqm_reg_write(reg++, *data++);
	}
	return messages;
}

void __weak dqm_set_tx(struct dqm *q)
{
	q->tx = dqm_generic_tx;
}
