/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#ifndef __DQNET_BRCMTAG_H_
#define __DQNET_BRCMTAG_H_

/*
 * This tag length is 4 bytes, older ones were 6 bytes, we do not
 * handle them.
 */
#define BRCM_TAG_LEN	4
#define BRCM_OPCODE_0		0x0
#define BRCM_OPCODE_1		0x1

static inline int dqnet_get_brcm_tag_len(struct dqnet_netdev *ndev)
{
	return ndev->brcm_tag ? BRCM_TAG_LEN : 0;
}
int dqnet_decode_brcm_tag(u8 *brcm_tag, u8 *port);
int dqnet_encode_brcm_tag(u8 port, u32 opcode, u32 priority, u8 *brcm_tag);
int dqnet_rm_brcm_tag(struct dqnet_netdev *ndev, struct fpm_buff *pb);
int dqnet_add_brcm_tag(struct dqnet_netdev *ndev, struct fpm_buff *fb);

#endif
