/* valapropertyaccessor.c generated by valac, the Vala compiler
 * generated from valapropertyaccessor.vala, do not modify */

/* valapropertyaccessor.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaPropertyAccessorPrivate {
	gboolean _readable;
	gboolean _writable;
	gboolean _construction;
	gboolean _automatic_body;
	ValaParameter* _value_parameter;
	ValaDataType* _value_type;
};

static gint ValaPropertyAccessor_private_offset;
static gpointer vala_property_accessor_parent_class = NULL;

static void vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                            ValaDataType* value);
static void vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                              gboolean value);
static void vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                                gboolean value);
static void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                                 ValaParameter* value);
static void vala_property_accessor_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static gboolean vala_property_accessor_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                               ValaDataType* old_type,
                                               ValaDataType* new_type);
static void vala_property_accessor_finalize (ValaCodeNode * obj);
static GType vala_property_accessor_get_type_once (void);

static inline gpointer
vala_property_accessor_get_instance_private (ValaPropertyAccessor* self)
{
	return G_STRUCT_MEMBER_P (self, ValaPropertyAccessor_private_offset);
}

ValaProperty*
vala_property_accessor_get_prop (ValaPropertyAccessor* self)
{
	ValaProperty* result;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	result = VALA_IS_PROPERTY (_tmp1_) ? ((ValaProperty*) _tmp1_) : NULL;
	return result;
}

ValaDataType*
vala_property_accessor_get_value_type (ValaPropertyAccessor* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                       ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_type);
	self->priv->_value_type = _tmp0_;
	if (value != NULL) {
		ValaDataType* _tmp1_;
		_tmp1_ = self->priv->_value_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	}
}

gboolean
vala_property_accessor_get_readable (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_readable;
	return result;
}

static void
vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_readable = value;
}

gboolean
vala_property_accessor_get_writable (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_writable;
	return result;
}

static void
vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_writable = value;
}

gboolean
vala_property_accessor_get_construction (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_construction;
	return result;
}

static void
vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_construction = value;
}

gboolean
vala_property_accessor_get_automatic_body (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic_body;
	return result;
}

static void
vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_automatic_body = value;
}

static gboolean
vala_property_accessor_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaPropertyAccessor* self;
	gboolean _tmp0_;
	self = (ValaPropertyAccessor*) base;
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}

ValaParameter*
vala_property_accessor_get_value_parameter (ValaPropertyAccessor* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_parameter;
	result = _tmp0_;
	return result;
}

static void
vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                            ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	self->priv->_value_parameter = _tmp0_;
}

/**
 * Creates a new property accessor.
 *
 * @param readable           true if get accessor, false otherwise
 * @param writable           true if set accessor, false otherwise
 * @param construction       true if construct accessor, false otherwise
 * @param body               accessor body
 * @param source_reference   reference to source code
 * @return                   newly created property accessor
 */
ValaPropertyAccessor*
vala_property_accessor_construct (GType object_type,
                                  gboolean readable,
                                  gboolean writable,
                                  gboolean construction,
                                  ValaDataType* value_type,
                                  ValaBlock* body,
                                  ValaSourceReference* source_reference,
                                  ValaComment* comment)
{
	ValaPropertyAccessor* self = NULL;
	self = (ValaPropertyAccessor*) vala_subroutine_construct (object_type, NULL, source_reference, comment);
	vala_property_accessor_set_readable (self, readable);
	vala_property_accessor_set_writable (self, writable);
	vala_property_accessor_set_construction (self, construction);
	vala_property_accessor_set_value_type (self, value_type);
	vala_subroutine_set_body ((ValaSubroutine*) self, body);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}

ValaPropertyAccessor*
vala_property_accessor_new (gboolean readable,
                            gboolean writable,
                            gboolean construction,
                            ValaDataType* value_type,
                            ValaBlock* body,
                            ValaSourceReference* source_reference,
                            ValaComment* comment)
{
	return vala_property_accessor_construct (VALA_TYPE_PROPERTY_ACCESSOR, readable, writable, construction, value_type, body, source_reference, comment);
}

static void
vala_property_accessor_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property_accessor (visitor, self);
}

static void
vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaLocalVariable* _tmp2_;
	ValaLocalVariable* _tmp3_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaLocalVariable* _tmp4_;
		ValaLocalVariable* _tmp5_;
		_tmp4_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	_tmp6_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaBlock* _tmp8_;
		ValaBlock* _tmp9_;
		_tmp8_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

/**
 * Get the method representing this property accessor
 * @return   null if the accessor is neither readable nor writable
 */
ValaMethod*
vala_property_accessor_get_method (ValaPropertyAccessor* self)
{
	ValaMethod* m = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp32_;
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	m = NULL;
	_tmp0_ = self->priv->_readable;
	if (_tmp0_) {
		ValaProperty* _tmp1_;
		ValaProperty* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaComment* _tmp11_;
		ValaComment* _tmp12_;
		ValaMethod* _tmp13_;
		_tmp1_ = vala_property_accessor_get_prop (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("get_%s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_property_accessor_get_value_type (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_comment ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_new (_tmp6_, _tmp8_, _tmp10_, _tmp12_);
		_vala_code_node_unref0 (m);
		m = _tmp13_;
		_g_free0 (_tmp6_);
	} else {
		gboolean _tmp14_;
		_tmp14_ = self->priv->_writable;
		if (_tmp14_) {
			ValaProperty* _tmp15_;
			ValaProperty* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			ValaVoidType* _tmp21_;
			ValaVoidType* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaComment* _tmp25_;
			ValaComment* _tmp26_;
			ValaMethod* _tmp27_;
			ValaMethod* _tmp28_;
			ValaParameter* _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			_tmp15_ = vala_property_accessor_get_prop (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("set_%s", _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_void_type_new (NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_symbol_get_comment ((ValaSymbol*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_method_new (_tmp20_, (ValaDataType*) _tmp22_, _tmp24_, _tmp26_);
			_vala_code_node_unref0 (m);
			m = _tmp27_;
			_vala_code_node_unref0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp28_ = m;
			_tmp29_ = self->priv->_value_parameter;
			_tmp30_ = vala_parameter_copy (_tmp29_);
			_tmp31_ = _tmp30_;
			vala_callable_add_parameter ((ValaCallable*) _tmp28_, _tmp31_);
			_vala_code_node_unref0 (_tmp31_);
		}
	}
	_tmp32_ = m;
	if (_tmp32_ != NULL) {
		ValaMethod* _tmp33_;
		ValaProperty* _tmp34_;
		ValaProperty* _tmp35_;
		ValaScope* _tmp36_;
		ValaScope* _tmp37_;
		ValaMethod* _tmp38_;
		ValaSymbolAccessibility _tmp39_;
		ValaSymbolAccessibility _tmp40_;
		ValaMethod* _tmp41_;
		ValaProperty* _tmp42_;
		ValaProperty* _tmp43_;
		ValaMemberBinding _tmp44_;
		ValaMemberBinding _tmp45_;
		ValaMethod* _tmp46_;
		ValaProperty* _tmp47_;
		ValaProperty* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		ValaMethod* _tmp51_;
		ValaProperty* _tmp52_;
		ValaProperty* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		ValaMethod* _tmp56_;
		ValaProperty* _tmp57_;
		ValaProperty* _tmp58_;
		ValaParameter* _tmp59_;
		ValaParameter* _tmp60_;
		ValaMethod* _tmp61_;
		ValaProperty* _tmp62_;
		ValaProperty* _tmp63_;
		_tmp33_ = m;
		_tmp34_ = vala_property_accessor_get_prop (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_symbol_get_owner ((ValaSymbol*) _tmp35_);
		_tmp37_ = _tmp36_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp33_, _tmp37_);
		_tmp38_ = m;
		_tmp39_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp40_ = _tmp39_;
		vala_symbol_set_access ((ValaSymbol*) _tmp38_, _tmp40_);
		_tmp41_ = m;
		_tmp42_ = vala_property_accessor_get_prop (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_property_get_binding (_tmp43_);
		_tmp45_ = _tmp44_;
		vala_method_set_binding (_tmp41_, _tmp45_);
		_tmp46_ = m;
		_tmp47_ = vala_property_accessor_get_prop (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_property_get_is_abstract (_tmp48_);
		_tmp50_ = _tmp49_;
		vala_method_set_is_abstract (_tmp46_, _tmp50_);
		_tmp51_ = m;
		_tmp52_ = vala_property_accessor_get_prop (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_property_get_is_virtual (_tmp53_);
		_tmp55_ = _tmp54_;
		vala_method_set_is_virtual (_tmp51_, _tmp55_);
		_tmp56_ = m;
		_tmp57_ = vala_property_accessor_get_prop (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_property_get_this_parameter (_tmp58_);
		_tmp60_ = _tmp59_;
		vala_method_set_this_parameter (_tmp56_, _tmp60_);
		_tmp61_ = m;
		_tmp62_ = vala_property_accessor_get_prop (self);
		_tmp63_ = _tmp62_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp61_, (ValaCodeNode*) _tmp63_, "GIR", "visible");
	}
	result = m;
	return result;
}

static gboolean
vala_property_accessor_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaPropertyAccessor * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSemanticAnalyzer* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	ValaProfile _tmp33_;
	ValaProfile _tmp34_;
	ValaProperty* _tmp99_;
	ValaProperty* _tmp100_;
	ValaSourceFileType _tmp101_;
	ValaSourceFileType _tmp102_;
	gboolean _tmp158_ = FALSE;
	gboolean _tmp159_ = FALSE;
	gboolean _tmp160_ = FALSE;
	ValaProperty* _tmp161_;
	ValaProperty* _tmp162_;
	gboolean _tmp163_;
	gboolean _tmp164_;
	gboolean _tmp181_ = FALSE;
	ValaProfile _tmp182_;
	ValaProfile _tmp183_;
	gboolean _tmp210_ = FALSE;
	ValaBlock* _tmp211_;
	ValaBlock* _tmp212_;
	ValaBlock* _tmp223_;
	ValaBlock* _tmp224_;
	gboolean _tmp238_ = FALSE;
	ValaBlock* _tmp239_;
	ValaBlock* _tmp240_;
	ValaSemanticAnalyzer* _tmp267_;
	ValaSemanticAnalyzer* _tmp268_;
	ValaSymbol* _tmp269_;
	gboolean _tmp270_;
	gboolean _tmp271_;
	gboolean result;
	self = (ValaPropertyAccessor*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_property_accessor_get_value_type (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_code_context_get_analyzer (context);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_semantic_analyzer_get_current_symbol (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _vala_code_node_ref0 (_tmp9_);
	old_symbol = _tmp10_;
	_tmp11_ = vala_code_context_get_analyzer (context);
	_tmp12_ = _tmp11_;
	vala_semantic_analyzer_set_current_symbol (_tmp12_, (ValaSymbol*) self);
	_tmp14_ = self->priv->_writable;
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp15_;
		_tmp15_ = self->priv->_construction;
		_tmp13_ = _tmp15_;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaParameter* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		ValaProperty* _tmp23_;
		ValaProperty* _tmp24_;
		ValaParameter* _tmp25_;
		ValaProperty* _tmp26_;
		ValaProperty* _tmp27_;
		ValaParameter* _tmp28_;
		ValaProperty* _tmp29_;
		ValaProperty* _tmp30_;
		_tmp16_ = vala_property_accessor_get_value_type (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_parameter_new ("value", _tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_property_accessor_set_value_parameter (self, _tmp21_);
		_vala_code_node_unref0 (_tmp21_);
		_tmp22_ = self->priv->_value_parameter;
		_tmp23_ = vala_property_accessor_get_prop (self);
		_tmp24_ = _tmp23_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp22_, (ValaCodeNode*) _tmp24_, "CCode", "array_length");
		_tmp25_ = self->priv->_value_parameter;
		_tmp26_ = vala_property_accessor_get_prop (self);
		_tmp27_ = _tmp26_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp25_, (ValaCodeNode*) _tmp27_, "CCode", "array_null_terminated");
		_tmp28_ = self->priv->_value_parameter;
		_tmp29_ = vala_property_accessor_get_prop (self);
		_tmp30_ = _tmp29_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp28_, (ValaCodeNode*) _tmp30_, "CCode", "delegate_target");
	}
	_tmp33_ = vala_code_context_get_profile (context);
	_tmp34_ = _tmp33_;
	if (_tmp34_ == VALA_PROFILE_GOBJECT) {
		gboolean _tmp35_;
		_tmp35_ = self->priv->_readable;
		_tmp32_ = _tmp35_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		ValaProperty* _tmp36_;
		ValaProperty* _tmp37_;
		ValaSymbol* _tmp38_;
		ValaSymbol* _tmp39_;
		ValaSemanticAnalyzer* _tmp40_;
		ValaSemanticAnalyzer* _tmp41_;
		ValaClass* _tmp42_;
		_tmp36_ = vala_property_accessor_get_prop (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_context_get_analyzer (context);
		_tmp41_ = _tmp40_;
		_tmp42_ = _tmp41_->object_type;
		_tmp31_ = vala_typesymbol_is_subtype_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), (ValaTypeSymbol*) _tmp42_);
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		ValaProperty* _tmp43_;
		ValaProperty* _tmp44_;
		ValaAttribute* _tmp45_;
		_tmp43_ = vala_property_accessor_get_prop (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp44_, "NoAccessorMethod");
		if (_tmp45_ != NULL) {
			ValaDataType* _tmp46_;
			ValaDataType* _tmp47_;
			_tmp46_ = vala_property_accessor_get_value_type (self);
			_tmp47_ = _tmp46_;
			if (vala_data_type_is_real_struct_type (_tmp47_)) {
				gboolean _tmp48_ = FALSE;
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp50_ = _tmp49_;
				if (_tmp50_ == NULL) {
					_tmp48_ = TRUE;
				} else {
					ValaSourceReference* _tmp51_;
					ValaSourceReference* _tmp52_;
					ValaSourceFile* _tmp53_;
					ValaSourceFile* _tmp54_;
					_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp52_ = _tmp51_;
					_tmp53_ = vala_source_reference_get_file (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp48_ = _tmp54_ == NULL;
				}
				if (_tmp48_) {
				} else {
					gboolean _tmp55_ = FALSE;
					ValaDataType* _tmp56_;
					ValaDataType* _tmp57_;
					gboolean _tmp58_;
					gboolean _tmp59_;
					_tmp56_ = vala_property_accessor_get_value_type (self);
					_tmp57_ = _tmp56_;
					_tmp58_ = vala_data_type_get_value_owned (_tmp57_);
					_tmp59_ = _tmp58_;
					if (!_tmp59_) {
						ValaSourceReference* _tmp60_;
						ValaSourceReference* _tmp61_;
						ValaSourceFile* _tmp62_;
						ValaSourceFile* _tmp63_;
						ValaSourceFileType _tmp64_;
						ValaSourceFileType _tmp65_;
						_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp61_ = _tmp60_;
						_tmp62_ = vala_source_reference_get_file (_tmp61_);
						_tmp63_ = _tmp62_;
						_tmp64_ = vala_source_file_get_file_type (_tmp63_);
						_tmp65_ = _tmp64_;
						_tmp55_ = _tmp65_ == VALA_SOURCE_FILE_TYPE_SOURCE;
					} else {
						_tmp55_ = FALSE;
					}
					if (_tmp55_) {
						ValaSourceReference* _tmp66_;
						ValaSourceReference* _tmp67_;
						ValaProperty* _tmp68_;
						ValaProperty* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp67_ = _tmp66_;
						_tmp68_ = vala_property_accessor_get_prop (self);
						_tmp69_ = _tmp68_;
						_tmp70_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp69_);
						_tmp71_ = _tmp70_;
						vala_report_error (_tmp67_, "unowned return value for getter of property `%s' not supported without" \
" accessor", _tmp71_);
						_g_free0 (_tmp71_);
					}
				}
			} else {
				gboolean _tmp72_ = FALSE;
				ValaDataType* _tmp73_;
				ValaDataType* _tmp74_;
				gboolean _tmp75_;
				gboolean _tmp76_;
				_tmp73_ = vala_property_accessor_get_value_type (self);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_data_type_get_value_owned (_tmp74_);
				_tmp76_ = _tmp75_;
				if (_tmp76_) {
					gboolean _tmp77_ = FALSE;
					ValaSourceReference* _tmp78_;
					ValaSourceReference* _tmp79_;
					_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp79_ = _tmp78_;
					if (_tmp79_ == NULL) {
						_tmp77_ = TRUE;
					} else {
						ValaSourceReference* _tmp80_;
						ValaSourceReference* _tmp81_;
						ValaSourceFile* _tmp82_;
						ValaSourceFile* _tmp83_;
						_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp81_ = _tmp80_;
						_tmp82_ = vala_source_reference_get_file (_tmp81_);
						_tmp83_ = _tmp82_;
						_tmp77_ = _tmp83_ == NULL;
					}
					_tmp72_ = _tmp77_;
				} else {
					_tmp72_ = FALSE;
				}
				if (_tmp72_) {
					gboolean _tmp84_ = FALSE;
					gboolean _tmp85_ = FALSE;
					ValaDataType* _tmp86_;
					ValaDataType* _tmp87_;
					_tmp86_ = vala_property_accessor_get_value_type (self);
					_tmp87_ = _tmp86_;
					if (VALA_IS_DELEGATE_TYPE (_tmp87_)) {
						_tmp85_ = TRUE;
					} else {
						ValaDataType* _tmp88_;
						ValaDataType* _tmp89_;
						_tmp88_ = vala_property_accessor_get_value_type (self);
						_tmp89_ = _tmp88_;
						_tmp85_ = VALA_IS_POINTER_TYPE (_tmp89_);
					}
					if (_tmp85_) {
						_tmp84_ = TRUE;
					} else {
						gboolean _tmp90_ = FALSE;
						ValaDataType* _tmp91_;
						ValaDataType* _tmp92_;
						_tmp91_ = vala_property_accessor_get_value_type (self);
						_tmp92_ = _tmp91_;
						if (VALA_IS_VALUE_TYPE (_tmp92_)) {
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							gboolean _tmp95_;
							gboolean _tmp96_;
							_tmp93_ = vala_property_accessor_get_value_type (self);
							_tmp94_ = _tmp93_;
							_tmp95_ = vala_data_type_get_nullable (_tmp94_);
							_tmp96_ = _tmp95_;
							_tmp90_ = !_tmp96_;
						} else {
							_tmp90_ = FALSE;
						}
						_tmp84_ = _tmp90_;
					}
					if (_tmp84_) {
						ValaDataType* _tmp97_;
						ValaDataType* _tmp98_;
						_tmp97_ = vala_property_accessor_get_value_type (self);
						_tmp98_ = _tmp97_;
						vala_data_type_set_value_owned (_tmp98_, FALSE);
					}
				}
			}
		}
	}
	_tmp99_ = vala_property_accessor_get_prop (self);
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_symbol_get_source_type ((ValaSymbol*) _tmp100_);
	_tmp102_ = _tmp101_;
	if (_tmp102_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_ = FALSE;
		ValaBlock* _tmp105_;
		ValaBlock* _tmp106_;
		_tmp105_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp106_ = _tmp105_;
		if (_tmp106_ == NULL) {
			ValaProperty* _tmp107_;
			ValaProperty* _tmp108_;
			gboolean _tmp109_;
			gboolean _tmp110_;
			_tmp107_ = vala_property_accessor_get_prop (self);
			_tmp108_ = _tmp107_;
			_tmp109_ = vala_property_get_interface_only (_tmp108_);
			_tmp110_ = _tmp109_;
			_tmp104_ = !_tmp110_;
		} else {
			_tmp104_ = FALSE;
		}
		if (_tmp104_) {
			ValaProperty* _tmp111_;
			ValaProperty* _tmp112_;
			gboolean _tmp113_;
			gboolean _tmp114_;
			_tmp111_ = vala_property_accessor_get_prop (self);
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_property_get_is_abstract (_tmp112_);
			_tmp114_ = _tmp113_;
			_tmp103_ = !_tmp114_;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaSourceReference* _tmp115_;
			ValaSourceReference* _tmp116_;
			ValaBlock* _tmp117_;
			ValaBlock* _tmp118_;
			ValaMemberAccess* ma = NULL;
			ValaProperty* _tmp119_;
			ValaProperty* _tmp120_;
			const gchar* _tmp121_;
			const gchar* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			ValaSourceReference* _tmp125_;
			ValaSourceReference* _tmp126_;
			ValaMemberAccess* _tmp127_;
			ValaMemberAccess* _tmp128_;
			gboolean _tmp129_;
			vala_property_accessor_set_automatic_body (self, TRUE);
			_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp116_ = _tmp115_;
			_tmp117_ = vala_block_new (_tmp116_);
			_tmp118_ = _tmp117_;
			vala_subroutine_set_body ((ValaSubroutine*) self, _tmp118_);
			_vala_code_node_unref0 (_tmp118_);
			_tmp119_ = vala_property_accessor_get_prop (self);
			_tmp120_ = _tmp119_;
			_tmp121_ = vala_symbol_get_name ((ValaSymbol*) _tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = g_strdup_printf ("_%s", _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp126_ = _tmp125_;
			_tmp127_ = vala_member_access_new_simple (_tmp124_, _tmp126_);
			_tmp128_ = _tmp127_;
			_g_free0 (_tmp124_);
			ma = _tmp128_;
			_tmp129_ = self->priv->_readable;
			if (_tmp129_) {
				ValaBlock* _tmp130_;
				ValaBlock* _tmp131_;
				ValaMemberAccess* _tmp132_;
				ValaSourceReference* _tmp133_;
				ValaSourceReference* _tmp134_;
				ValaReturnStatement* _tmp135_;
				ValaReturnStatement* _tmp136_;
				_tmp130_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp131_ = _tmp130_;
				_tmp132_ = ma;
				_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_return_statement_new ((ValaExpression*) _tmp132_, _tmp134_);
				_tmp136_ = _tmp135_;
				vala_block_add_statement (_tmp131_, (ValaStatement*) _tmp136_);
				_vala_code_node_unref0 (_tmp136_);
			} else {
				ValaExpression* value = NULL;
				ValaSourceReference* _tmp137_;
				ValaSourceReference* _tmp138_;
				ValaMemberAccess* _tmp139_;
				ValaDataType* _tmp140_;
				ValaDataType* _tmp141_;
				gboolean _tmp142_;
				gboolean _tmp143_;
				ValaAssignment* assignment = NULL;
				ValaMemberAccess* _tmp148_;
				ValaExpression* _tmp149_;
				ValaSourceReference* _tmp150_;
				ValaSourceReference* _tmp151_;
				ValaAssignment* _tmp152_;
				ValaBlock* _tmp153_;
				ValaBlock* _tmp154_;
				ValaAssignment* _tmp155_;
				ValaExpressionStatement* _tmp156_;
				ValaExpressionStatement* _tmp157_;
				_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp138_ = _tmp137_;
				_tmp139_ = vala_member_access_new_simple ("value", _tmp138_);
				value = (ValaExpression*) _tmp139_;
				_tmp140_ = vala_property_accessor_get_value_type (self);
				_tmp141_ = _tmp140_;
				_tmp142_ = vala_data_type_get_value_owned (_tmp141_);
				_tmp143_ = _tmp142_;
				if (_tmp143_) {
					ValaExpression* _tmp144_;
					ValaSourceReference* _tmp145_;
					ValaSourceReference* _tmp146_;
					ValaReferenceTransferExpression* _tmp147_;
					_tmp144_ = value;
					_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp146_ = _tmp145_;
					_tmp147_ = vala_reference_transfer_expression_new (_tmp144_, _tmp146_);
					_vala_code_node_unref0 (value);
					value = (ValaExpression*) _tmp147_;
				}
				_tmp148_ = ma;
				_tmp149_ = value;
				_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp151_ = _tmp150_;
				_tmp152_ = vala_assignment_new ((ValaExpression*) _tmp148_, _tmp149_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp151_);
				assignment = _tmp152_;
				_tmp153_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp154_ = _tmp153_;
				_tmp155_ = assignment;
				_tmp156_ = vala_expression_statement_new ((ValaExpression*) _tmp155_, NULL);
				_tmp157_ = _tmp156_;
				vala_block_add_statement (_tmp154_, (ValaStatement*) _tmp157_);
				_vala_code_node_unref0 (_tmp157_);
				_vala_code_node_unref0 (assignment);
				_vala_code_node_unref0 (value);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp161_ = vala_property_accessor_get_prop (self);
	_tmp162_ = _tmp161_;
	_tmp163_ = vala_property_get_is_abstract (_tmp162_);
	_tmp164_ = _tmp163_;
	if (_tmp164_) {
		_tmp160_ = TRUE;
	} else {
		ValaProperty* _tmp165_;
		ValaProperty* _tmp166_;
		gboolean _tmp167_;
		gboolean _tmp168_;
		_tmp165_ = vala_property_accessor_get_prop (self);
		_tmp166_ = _tmp165_;
		_tmp167_ = vala_property_get_is_virtual (_tmp166_);
		_tmp168_ = _tmp167_;
		_tmp160_ = _tmp168_;
	}
	if (_tmp160_) {
		_tmp159_ = TRUE;
	} else {
		ValaProperty* _tmp169_;
		ValaProperty* _tmp170_;
		gboolean _tmp171_;
		gboolean _tmp172_;
		_tmp169_ = vala_property_accessor_get_prop (self);
		_tmp170_ = _tmp169_;
		_tmp171_ = vala_property_get_overrides (_tmp170_);
		_tmp172_ = _tmp171_;
		_tmp159_ = _tmp172_;
	}
	if (_tmp159_) {
		ValaSymbolAccessibility _tmp173_;
		ValaSymbolAccessibility _tmp174_;
		_tmp173_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp174_ = _tmp173_;
		_tmp158_ = _tmp174_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	} else {
		_tmp158_ = FALSE;
	}
	if (_tmp158_) {
		ValaSourceReference* _tmp175_;
		ValaSourceReference* _tmp176_;
		ValaProperty* _tmp177_;
		ValaProperty* _tmp178_;
		gchar* _tmp179_;
		gchar* _tmp180_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp176_ = _tmp175_;
		_tmp177_ = vala_property_accessor_get_prop (self);
		_tmp178_ = _tmp177_;
		_tmp179_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp178_);
		_tmp180_ = _tmp179_;
		vala_report_error (_tmp176_, "Property `%s' with private accessor cannot be marked as abstract, virt" \
"ual or override", _tmp180_);
		_g_free0 (_tmp180_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp182_ = vala_code_context_get_profile (context);
	_tmp183_ = _tmp182_;
	if (_tmp183_ == VALA_PROFILE_POSIX) {
		gboolean _tmp184_;
		_tmp184_ = self->priv->_construction;
		_tmp181_ = _tmp184_;
	} else {
		_tmp181_ = FALSE;
	}
	if (_tmp181_) {
		ValaSourceReference* _tmp185_;
		ValaSourceReference* _tmp186_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp186_ = _tmp185_;
		vala_report_error (_tmp186_, "`construct' is not supported in POSIX profile");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	} else {
		gboolean _tmp187_ = FALSE;
		gboolean _tmp188_;
		_tmp188_ = self->priv->_construction;
		if (_tmp188_) {
			ValaProperty* _tmp189_;
			ValaProperty* _tmp190_;
			ValaSymbol* _tmp191_;
			ValaSymbol* _tmp192_;
			ValaSemanticAnalyzer* _tmp193_;
			ValaSemanticAnalyzer* _tmp194_;
			ValaClass* _tmp195_;
			_tmp189_ = vala_property_accessor_get_prop (self);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp190_);
			_tmp192_ = _tmp191_;
			_tmp193_ = vala_code_context_get_analyzer (context);
			_tmp194_ = _tmp193_;
			_tmp195_ = _tmp194_->object_type;
			_tmp187_ = !vala_typesymbol_is_subtype_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), (ValaTypeSymbol*) _tmp195_);
		} else {
			_tmp187_ = FALSE;
		}
		if (_tmp187_) {
			ValaSourceReference* _tmp196_;
			ValaSourceReference* _tmp197_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp197_ = _tmp196_;
			vala_report_error (_tmp197_, "construct properties require `GLib.Object'");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			return result;
		} else {
			gboolean _tmp198_ = FALSE;
			gboolean _tmp199_;
			_tmp199_ = self->priv->_construction;
			if (_tmp199_) {
				ValaSemanticAnalyzer* _tmp200_;
				ValaSemanticAnalyzer* _tmp201_;
				ValaProperty* _tmp202_;
				ValaProperty* _tmp203_;
				_tmp200_ = vala_code_context_get_analyzer (context);
				_tmp201_ = _tmp200_;
				_tmp202_ = vala_property_accessor_get_prop (self);
				_tmp203_ = _tmp202_;
				_tmp198_ = !vala_semantic_analyzer_is_gobject_property (_tmp201_, _tmp203_);
			} else {
				_tmp198_ = FALSE;
			}
			if (_tmp198_) {
				gboolean _tmp204_;
				gboolean _tmp205_;
				_tmp204_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp205_ = _tmp204_;
				if (_tmp205_) {
					ValaSourceReference* _tmp206_;
					ValaSourceReference* _tmp207_;
					_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp207_ = _tmp206_;
					vala_report_warning (_tmp207_, "construct properties not supported for specified property type");
				} else {
					ValaSourceReference* _tmp208_;
					ValaSourceReference* _tmp209_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp209_ = _tmp208_;
					vala_report_error (_tmp209_, "construct properties not supported for specified property type");
					result = FALSE;
					_vala_code_node_unref0 (old_symbol);
					return result;
				}
			}
		}
	}
	_tmp211_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp212_ = _tmp211_;
	if (_tmp212_ != NULL) {
		ValaProperty* _tmp213_;
		ValaProperty* _tmp214_;
		gboolean _tmp215_;
		gboolean _tmp216_;
		_tmp213_ = vala_property_accessor_get_prop (self);
		_tmp214_ = _tmp213_;
		_tmp215_ = vala_property_get_is_abstract (_tmp214_);
		_tmp216_ = _tmp215_;
		_tmp210_ = _tmp216_;
	} else {
		_tmp210_ = FALSE;
	}
	if (_tmp210_) {
		ValaSourceReference* _tmp217_;
		ValaSourceReference* _tmp218_;
		ValaProperty* _tmp219_;
		ValaProperty* _tmp220_;
		gchar* _tmp221_;
		gchar* _tmp222_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp218_ = _tmp217_;
		_tmp219_ = vala_property_accessor_get_prop (self);
		_tmp220_ = _tmp219_;
		_tmp221_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp220_);
		_tmp222_ = _tmp221_;
		vala_report_error (_tmp218_, "Accessor of abstract property `%s' cannot have body", _tmp222_);
		_g_free0 (_tmp222_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp223_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp224_ = _tmp223_;
	if (_tmp224_ != NULL) {
		gboolean _tmp225_ = FALSE;
		gboolean _tmp226_;
		ValaBlock* _tmp236_;
		ValaBlock* _tmp237_;
		_tmp226_ = self->priv->_writable;
		if (_tmp226_) {
			_tmp225_ = TRUE;
		} else {
			gboolean _tmp227_;
			_tmp227_ = self->priv->_construction;
			_tmp225_ = _tmp227_;
		}
		if (_tmp225_) {
			ValaBlock* _tmp228_;
			ValaBlock* _tmp229_;
			ValaScope* _tmp230_;
			ValaScope* _tmp231_;
			ValaParameter* _tmp232_;
			const gchar* _tmp233_;
			const gchar* _tmp234_;
			ValaParameter* _tmp235_;
			_tmp228_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp229_ = _tmp228_;
			_tmp230_ = vala_symbol_get_scope ((ValaSymbol*) _tmp229_);
			_tmp231_ = _tmp230_;
			_tmp232_ = self->priv->_value_parameter;
			_tmp233_ = vala_symbol_get_name ((ValaSymbol*) _tmp232_);
			_tmp234_ = _tmp233_;
			_tmp235_ = self->priv->_value_parameter;
			vala_scope_add (_tmp231_, _tmp234_, (ValaSymbol*) _tmp235_);
		}
		_tmp236_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp237_ = _tmp236_;
		vala_code_node_check ((ValaCodeNode*) _tmp237_, context);
	}
	_tmp239_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp240_ = _tmp239_;
	if (_tmp240_ != NULL) {
		ValaBlock* _tmp241_;
		ValaBlock* _tmp242_;
		gboolean _tmp243_;
		gboolean _tmp244_;
		_tmp241_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp242_ = _tmp241_;
		_tmp243_ = vala_code_node_get_error ((ValaCodeNode*) _tmp242_);
		_tmp244_ = _tmp243_;
		_tmp238_ = !_tmp244_;
	} else {
		_tmp238_ = FALSE;
	}
	if (_tmp238_) {
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp245_;
		ValaArrayList* _tmp246_;
		ValaBlock* _tmp247_;
		ValaBlock* _tmp248_;
		ValaArrayList* _tmp249_;
		_tmp245_ = g_direct_equal;
		_tmp246_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp245_);
		error_types = _tmp246_;
		_tmp247_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp248_ = _tmp247_;
		_tmp249_ = error_types;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp248_, (ValaCollection*) _tmp249_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp250_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp251_;
			gint _tmp252_;
			gint _tmp253_;
			gint _body_error_type_index = 0;
			_tmp250_ = error_types;
			_body_error_type_list = _tmp250_;
			_tmp251_ = _body_error_type_list;
			_tmp252_ = vala_collection_get_size ((ValaCollection*) _tmp251_);
			_tmp253_ = _tmp252_;
			_body_error_type_size = _tmp253_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp254_;
				gint _tmp255_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp256_;
				gpointer _tmp257_;
				ValaDataType* _tmp258_;
				gboolean _tmp259_;
				gboolean _tmp260_;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp254_ = _body_error_type_index;
				_tmp255_ = _body_error_type_size;
				if (!(_tmp254_ < _tmp255_)) {
					break;
				}
				_tmp256_ = _body_error_type_list;
				_tmp257_ = vala_list_get ((ValaList*) _tmp256_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp257_;
				_tmp258_ = body_error_type;
				_tmp259_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp258_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
				_tmp260_ = _tmp259_;
				if (!_tmp260_) {
					ValaDataType* _tmp261_;
					ValaSourceReference* _tmp262_;
					ValaSourceReference* _tmp263_;
					ValaDataType* _tmp264_;
					gchar* _tmp265_;
					gchar* _tmp266_;
					_tmp261_ = body_error_type;
					_tmp262_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp261_);
					_tmp263_ = _tmp262_;
					_tmp264_ = body_error_type;
					_tmp265_ = vala_code_node_to_string ((ValaCodeNode*) _tmp264_);
					_tmp266_ = _tmp265_;
					vala_report_warning (_tmp263_, "unhandled error `%s'", _tmp266_);
					_g_free0 (_tmp266_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
		}
		_vala_iterable_unref0 (error_types);
	}
	_tmp267_ = vala_code_context_get_analyzer (context);
	_tmp268_ = _tmp267_;
	_tmp269_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp268_, _tmp269_);
	_tmp270_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp271_ = _tmp270_;
	result = !_tmp271_;
	_vala_code_node_unref0 (old_symbol);
	return result;
}

static void
vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                          ValaDataType* old_type,
                                          ValaDataType* new_type)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_property_accessor_set_value_type (self, new_type);
	}
}

static void
vala_property_accessor_class_init (ValaPropertyAccessorClass * klass,
                                   gpointer klass_data)
{
	vala_property_accessor_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_accessor_finalize;
	g_type_class_adjust_private_offset (klass, &ValaPropertyAccessor_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_property_accessor_real_check;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_property_accessor_real_replace_type;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_property_accessor_real_get_has_result;
}

static void
vala_property_accessor_instance_init (ValaPropertyAccessor * self,
                                      gpointer klass)
{
	self->priv = vala_property_accessor_get_instance_private (self);
}

static void
vala_property_accessor_finalize (ValaCodeNode * obj)
{
	ValaPropertyAccessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	_vala_code_node_unref0 (self->priv->_value_type);
	VALA_CODE_NODE_CLASS (vala_property_accessor_parent_class)->finalize (obj);
}

/**
 * Represents a get or set accessor of a property in the source code.
 */
static GType
vala_property_accessor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyAccessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_accessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPropertyAccessor), 0, (GInstanceInitFunc) vala_property_accessor_instance_init, NULL };
	GType vala_property_accessor_type_id;
	vala_property_accessor_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaPropertyAccessor", &g_define_type_info, 0);
	ValaPropertyAccessor_private_offset = g_type_add_instance_private (vala_property_accessor_type_id, sizeof (ValaPropertyAccessorPrivate));
	return vala_property_accessor_type_id;
}

GType
vala_property_accessor_get_type (void)
{
	static volatile gsize vala_property_accessor_type_id__once = 0;
	if (g_once_init_enter (&vala_property_accessor_type_id__once)) {
		GType vala_property_accessor_type_id;
		vala_property_accessor_type_id = vala_property_accessor_get_type_once ();
		g_once_init_leave (&vala_property_accessor_type_id__once, vala_property_accessor_type_id);
	}
	return vala_property_accessor_type_id__once;
}

