 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef VFLASH_H
#define VFLASH_H
/*
#define CONFIG_BCM_VFLASH_DEBUG
#define VFLASH_PROC_DEBUG
*/
#ifdef CONFIG_BCM_VFLASH_DEBUG
#define MSG_TRACE(level, format, ...) pr_debug(level format, ##__VA_ARGS__)
#define ERR_TRACE(level, format, ...) pr_err(level format, ##__VA_ARGS__)
#define FUNC_TRACE(x) \
	pr_debug(MSG_LEVEL_FUNC_TRACE "%s %s\n", x ? "->" : "<-", __func__)
#define FUNC_TRACEF(x, format, ...) \
	pr_debug(MSG_LEVEL_FUNC_TRACE "%s %s " format, x ? "->" : "<-", \
		__func__, __VA_ARGS__);
#define MSG_TRACEN(...) MSG_TRACE(MSG_LEVEL_NOISE, __VA_ARGS__)
#define MSG_TRACEI(...) MSG_TRACE(MSG_LEVEL_INFO, __VA_ARGS__)
#define MSG_TRACEE(...) ERR_TRACE(MSG_LEVEL_ERROR, __VA_ARGS__)

#define MSG_LEVEL_FUNC_TRACE "[vf:f]"
#define MSG_LEVEL_NOISE "[vf:n]"
#define MSG_LEVEL_INFO "[vf:i]"
#define MSG_LEVEL_ERROR "[vf:e]"
#else   /* #ifdef CONFIG_BCM_VFLASH_DEBUG */
#define ERR_TRACE(format, ...) pr_err(format, ##__VA_ARGS__)
#define FUNC_TRACE(x)
#define FUNC_TRACEF(x, format, ...)
#define MSG_TRACEN(...)
#define MSG_TRACEI(...)
#define MSG_TRACEE(...) ERR_TRACE(__VA_ARGS__)
#endif /* #ifdef CONFIG_BCM_VFLASH_DEBUG */


typedef enum
{
	kFlashTypeUnknown = 0,
	kFlashTypeNor,
	kFlashTypeNand
}   FlashType;

typedef enum
{
	VF_NOR_READ,
	VF_NAND_READ,
	VF_WRITE,
	VF_ERASE,
	VF_NAND_BLOCK_ISBAD,
	VF_NAND_BLOCK_MARKBAD,
	VF_INFO_DEVICE_CNT,
	VF_INFO_DEVICE_INFO,
	VF_INFO_PARTITION_INFO,
	VF_INFO_PARTITION_NAME,
	VF_INFO_CLIENT_REGISTER,
}	VFlashServices;

/* flash device and partition mapping structs */
struct vflash_msg
{
	u32  dqm_header;
	u8   region;
	u8   info;
	u16  pages;
	u32  offsetxpages;
	u8   *buffer;
};

struct vflash_msg_device_cnt
{
	u32  dqm_header;
	u32  devicecnt;
	u32  unused2;
};

struct vflash_msg_client_register
{
	u32  dqm_header;
	u32  sharedmem_addr;
	u32  sharedmem_size;
	u32  client_id;
};

struct vflash_msg_device_info
{
	u32  dqm_header;
	u8   device;
	u8   type;
	u8   partition_cnt;
	u8   first_partition;
	u16  page_size;
	u16  block_size_in_pages;
	u32  size_in_blocks;
};

struct vflash_msg_partition_info
{
	u32  dqm_header;
	u8   device;
	u8   partition;  /* contiguous mapping for this device */
	u8   region;     /* chaotic mapping in gFlashRegions[] */
	u8   read_only;
	u32  start_block;
	u32  end_block;
};

struct vflash_msg_partition_name
{
	u32  dqm_header;
	u8   region;
	u8   name[11];
};

/* IOCTL define */
#define VFS_BUFFSIZE       _IOR('M', 1, u32)

/* mtd nor flash layer ignores writesize and writes tiny buffers */
#define VF_MSG_TINY		(1 << 7)
#define VF_MSG_ERROR		(1 << 6)
#define VF_MSG_TRUE		(1 << 5)
#define VF_MSG_XTRA_BIT		(1 << 4)
#define VF_MSG_PAGSZ		0xf

static inline bool vflash_msg_tiny(struct vflash_msg *msg)
{
	return msg->info & VF_MSG_TINY;
}
static inline void vflash_msg_set_tiny(struct vflash_msg *msg)
{
	msg->info =  msg->info | VF_MSG_TINY;
}
static inline bool vflash_msg_error(struct vflash_msg *msg)
{
	return msg->info & VF_MSG_ERROR;
}
static inline void vflash_msg_set_error(struct vflash_msg *msg, bool err)
{
	msg->info =  err ? msg->info | VF_MSG_ERROR : msg->info & ~VF_MSG_ERROR;
}
static inline bool vflash_msg_true(struct vflash_msg *msg)
{
	return msg->info & VF_MSG_TRUE;
}
static inline void vflash_msg_set_true(struct vflash_msg *msg, bool yes)
{
	msg->info =  yes ? msg->info | VF_MSG_TRUE : msg->info & ~VF_MSG_TRUE;
}
static inline bool vflash_msg_xtrabit(struct vflash_msg *msg)
{
	return msg->info & VF_MSG_XTRA_BIT;
}
static inline void vflash_msg_set_xtrabit(struct vflash_msg *msg)
{
	msg->info =  msg->info | VF_MSG_XTRA_BIT;
}
static inline u32 vflash_msg_pagesize(struct vflash_msg *msg)
{
	return (1 << (msg->info & VF_MSG_PAGSZ));
}
static inline void vflash_msg_set_pagesize(struct vflash_msg *msg, int log2size)
{
	msg->info = log2size & VF_MSG_PAGSZ;
}
static inline u32 vflash_msg_bytes(struct vflash_msg *msg)
{
	if (vflash_msg_tiny(msg))
		return msg->pages;

	if (vflash_msg_xtrabit(msg)) {
		return ((1<<16) + msg->pages * vflash_msg_pagesize(msg));
	}
	return (msg->pages * vflash_msg_pagesize(msg));
}
static inline u32 vflash_msg_offset(struct vflash_msg *msg)
{
	if (vflash_msg_tiny(msg))
		return msg->offsetxpages;
	return (msg->offsetxpages * vflash_msg_pagesize(msg));
}
static inline u8 *vflash_msg_buf(struct vflash_msg *msg)
{
	return msg->buffer;
}
static inline u32 vflash_msg_block(struct vflash_msg *msg)
{
	return msg->offsetxpages;
}
static inline void vflash_msg_set_block(struct vflash_msg *msg, u32 block)
{
	msg->offsetxpages = block;
}
static inline void vflash_msg_partition_info_set_error(struct vflash_msg_partition_info *msg)
{
	msg->start_block = 0xffffffff;
}
static inline bool vflash_msg_partition_info_error(struct vflash_msg_partition_info *msg)
{
	return msg->start_block == 0xffffffff;
}

static inline bool vflash_msg_partition_size_error(struct vflash_msg_partition_name *msg)
{
	return msg->name[0] == 0xff;
}
static inline void vflash_msg_device_info_set_error(struct vflash_msg_device_info *msg)
{
	msg->type = 0xff;
}
static inline bool vflash_msg_device_info_error(struct vflash_msg_device_info *msg)
{
	return msg->type == 0xff;
}
static inline void vflash_msg_partition_name_set_error(struct vflash_msg_partition_name *msg)
{
	msg->name[0] = 0xff;
}
static inline bool vflash_msg_partition_name_error(struct vflash_msg_partition_name *msg)
{
	return msg->name[0] == 0xff;
}

#endif
