 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

/* Hard coded ATW/ARC mapping... Adjust as needed for your platform. */
/* Used only if CONFIG_BCM_BA_HARDCODE_MAP is defined, will also
* prevent the below settings from being defined or modified by
* device tree, or user space */

#if !defined(CONFIG_BCM_BA_HARDCODE_MAP)
#error Should not be including this header
#endif

static inline int ba_hardcode_map(struct ba_dev_info *info)
{
	struct ba_atw *atw;

	if (!info)
		return -1;

	info->map = devm_kzalloc(&info->pdev->dev, sizeof(struct ba_map),
				 GFP_KERNEL);
	if (!info->map)
		return -1;

	info->flags |= MAP_VALID;
	info->allow_user_map = false;

	info->map->rg.vm.start = 256 * 1024 * 1024,
	info->map->rg.vm.size = 108 * 1024 * 1024,
	info->map->rg.vm.cpus = 1,
#ifdef CONFIG_BCM7145A0
	atw = &info->map->rg.atw;
	atw->clients[1] = 0x2;
	atw->index = 0;
	atw->source = 256 * 1024 * 1024;
	atw->dest = 0xffff0000;
	atw->size = 64 * 1024;
#endif

	info->map->docsis.tp1.start = 364 * 1024 * 1024;
	info->map->docsis.tp1.size = 20 * 1024 * 1024;

	atw = &info->map->docsis.cm.cm_atw;
	atw->clients[0] = 0x4000FFFA;
	atw->index = 1;
	atw->source = 384 * 1024 * 1024;
	atw->dest = 0;
	atw->size = 32 * 1024 * 1024;

	atw = &info->map->docsis.cm.boot_atw;
	atw->clients[0] = 0x2;
	atw->index = 3;
	atw->source = 418 * 1024 * 1024;
	atw->dest = 508 * 1024 * 1024;
	atw->size = 64 * 1024;

	atw = &info->map->docsis.dsp.atw;
	atw->clients[0] = 0x4000FFFA;
	atw->index = 2;
	atw->source = 416 * 1024 * 1024;
	atw->dest = 126 * 1024 * 1024;
	atw->size = 2 * 1024 * 1024;

	info->map->docsis.xfer.start = 438370304;
	info->map->docsis.xfer.size = 128 * 1024;
	info->map->docsis.xfer.count = 2;

	info->map->docsis.leap.size = 1 * 1024 * 1024;

	memset(info->map->arc, 0xff, sizeof(info->map->arc));

	return 0;
};

/* TBD.. still get this from DT? */
#define BA_FPM_SIZE 33554432
