/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef __MSGFIFO_H__
#define __MSGFIFO_H__

/*
 * Maximum message offset length.
 * This length needs to be agreed upon by all parties so there is
 * no misunderstanding on what the offset size to be used is on all cores.
 * This size needs to cover max wifi header + VLAN headers + GRE tunnel headers, etc.
 * 16B Cache alligned
 * NOTE: Since wifi grabs 1952B packets for headers we are using the remainder
 * to stay within 2048 which currently is our max size.
 */
#define MAX_MSG_OFFSET          240

/* Token Defines */
#define TKN_VALID_TKN_BIT       0x80000000
#define TKN_VALID_TKN_SHIFT     31
#define TKN_RSVD_BIT            0x40000000
#define TKN_RSVD_SHIFT          30
#define TKN_BUF_INDX_MASK       0x3FFFF000
#define TKN_BUF_INDX_SHIFT      12
#define TKN_BUF_POOL_NUM_MASK   0x30000000
#define TKN_BUF_POOL_NUM_SHIFT  28
#define TKN_BUF_POOL_INDX_MASK  0x0FFFF000
#define TKN_BUF_POOL_INDX_SHIFT 12
#define TKN_SIZE_MASK           0x00000FFF
#define TKN_SIZE_SHIFT          0

/* Data Message Defines. */
enum msgids
{
    /* Start of Incoming/Outgoing MsgIds */
    LANRxMsg = 0,
    LANTxMsg = 1,
    TXStatusMsg = 2,
    DSPktMsg = 3,
    DSBpiSeqErrMsg = 4,
    DSPhsDiscardMsg = 5,
    USPPRequestMsg = 6,
    USPPResponseMsg = 7,
    DSPacketRxMsg = 8,
    LANPrePendMsg = 9,
    PacketOffloadSupportMsg = 10,
    USPacketTxMsg = 11,
    USReleaseTokenMsg = 12,
    USPPTxStatusMsg = 13,
    ItcRpcServiceMsg = 14,
    USLegacyMsg,
    LANRxMsgSkb = 30,
    LANTxMsgSkb = 31,
    /* Start of DQM MsgIds */
    CREATEFlowCmdMsg = 32,
    REMOVEFlowCmdMsg,
    CREATEFlowRspMsg,
    REMOVEFlowRspMsg,
    USPacketMsg,
    SHOWMibsCmdMsg,
    CLEARMibsCmdMsg,
    FLUSHFlowCmdMsg,
    fTESTModeCmdMsg,
    /* Start of test MsgIds */
    INSERTTokenMsg = 58,
    FLOWNotInserviceMsg = 59,
    TESTStart = 60,
    TESTStop,
    TESTEndPass,
    TESTEndFail
};

/*Message ID, READ and WRITE macro.*/
#define ID_MASK              0xfc000000
#define ID_SHIFT             26
#define MAC_ID_MASK          0x03c00000
#define MAC_ID_SHIFT         22
#define SUB_ID_MASK          0x0000f000
#define SUB_ID_SHIFT         12
#define WRITE_HDR_FIELD(msg,val,mask,shift)  (msg = ((val<<shift) & mask) | (msg & ~mask))
#define GET_MSG_ID(msg)                      (((msg&ID_MASK) >> ID_SHIFT))
#define READ_HDR_FIELD(msg,val,mask,shift)   (val = ((msg & mask)>>shift))
#define COMPARE_FIELD(msg, val, mask, shift) (((val << shift) & mask) != (msg & mask))

#define MAC_ID_UNIMAC      0  // DFAP Unimac
#define MAC_ID_ETHSW_0     1  // Switch Port 0 // RDD_LAN0_VPORT=RDD_VPORT_ID_1
#define MAC_ID_ETHSW_1     2  // Switch Port 1 // RDD_LAN1_VPORT=RDD_VPORT_ID_2
#define MAC_ID_ETHSW_2     3  // Switch Port 2 // RDD_LAN2_VPORT=RDD_VPORT_ID_3
#define MAC_ID_ETHSW_3     4  // Switch Port 3 // RDD_LAN3_VPORT=RDD_VPORT_ID_4
#define MAC_ID_ETHSW_4     5  // Switch Port 4 // RDD_LAN4_VPORT=RDD_VPORT_ID_5
#define MAC_ID_MOCA        5  // Moca          // RDD_LAN4_VPORT=RDD_VPORT_ID_5
#define MAC_ID_STB         6  //
#define MAC_ID_ETHSW_7     6  // ETH 2.5G Port // RDD_LAN5_VPORT=RDD_VPORT_ID_6
#define MAC_ID_WIFI0       8  // Wifi 0        // RDD_WIFI_VPORT=RDD_VPORT_ID_8  SUB_ID is (SSID)
#define MAC_ID_WIFI1       9  // Wifi 1
#define MAC_ID_WIFI2       10 // Wifi 2
#define MAC_ID_LINUXHOST   12 // Linux Host
#define MAC_ID_EMTA        13 // EMTA / Voice
#define MAC_ID_CMHOST      14 // Cablemodem Host / IPStacks
#define MAC_ID_CM          15 // DS/US
#define MAC_ID_EROUTER     MAC_ID_LINUXHOST
#define MAC_ID_ETHWAN      MAC_ID_UNIMAC

#define MAC_ID_ETHSW       0  // Switch Connection. (RouterUnimac 0,1). Note: SubId could be used for switch port.
#define MAC_ID_ETH         1  // Ethernet Connection Alternate  (StbUnimac)
#define MAC_ID_STB_B       13 // Set Top Bridged Connection.
#define MAC_ID_STB_R       14 // Set Top Routed  Connection.

/*LAN RX Offset Message or LAN RX SKB Message*/
struct lanrxoffsetmsg
{
    uint32_t msghdr;  /* Uses GenericTknMsgT to overlay*/
        #define LANRXO_MSG_ID_MASK     0xfc000000
        #define LANRXO_MSG_ID_SHIFT    26

    /* Define the MSG ID*/
#define LANRXO_MSG_ID           0
#define LANRXSKB_MSG_ID         30

#define LANRXO_MAC_ID_MASK     0x03c00000
#define LANRXO_MAC_ID_SHIFT    22

    /* Define the MAC IDs*/
#define LANRXO_MAC_ID_ETH0        MAC_ID_ETH0
#define LANRXO_MAC_ID_ETH1        MAC_ID_ETH1
#define LANRXO_MAC_ID_WIFI0       MAC_ID_WIFI0
#define LANRXO_MAC_ID_WIFI1       MAC_ID_WIFI1
#define LANRXO_MAC_ID_USB         MAC_ID_USB
#define LANRXO_MAC_ID_MOCA        MAC_ID_MOCA
#define LANRXO_MAC_ID_WIFI0_GST   MAC_ID_WIFI0_GST
#define LANRXO_MAC_ID_WIFI1_GST   MAC_ID_WIFI1_GST
#define LANRXO_MAC_ID_ITC         MAC_ID_APPS_ROUTED
#define LANRXO_MAC_ID_APPS        MAC_ID_APPS_ROUTED
#define LANRXO_MAC_ID_EROUTER     MAC_ID_EROUTER

#define LANRXO_QOS_MASK        0x000f0000
#define LANRXO_QOS_SHIFT       16
#define LANRXO_SUB_ID_MASK     0x0000f000
#define LANRXO_SUB_ID_SHIFT    12
#define LANRXO_EOP_MASK        0x00000800
#define LANRXO_EOP_SHIFT       11
#define LANRXO_OFFSET_MASK     0x000007ff
#define LANRXO_OFFSET_SHIFT    0
#define LANRXSKB_LEN_MASK      LANRXO_OFFSET_MASK
#define LANRXSKB_LEN_SHIFT     LANRXO_OFFSET_SHIFT
    union {
        uint32_t token;     /* FPM */
        uint32_t context;   /* SKB */
    };
    uint32_t addr;          /* SKB */
};


/*LAN TX Offset Message or LAN TX SKB Message */
struct lantxoffsetmsg
{
    uint32_t msghdr;  /* Uses GenericTknMsgT to overlay*/
        #define LANTXO_MSG_ID_MASK     0xfc000000
        #define LANTXO_MSG_ID_SHIFT    26

    /* Define the MSG ID*/
#define LANTXO_MSG_ID           1
#define LANTXSKB_MSG_ID         31

#define LANTXO_MAC_ID_MASK     0x03c00000
#define LANTXO_MAC_ID_SHIFT    22

    /* Define the MAC IDs*/
#define LANTXO_MAC_ID_ETH0        MAC_ID_ETH0
#define LANTXO_MAC_ID_ETH1        MAC_ID_ETH1
#define LANTXO_MAC_ID_WIFI0       MAC_ID_WIFI0
#define LANTXO_MAC_ID_WIFI1       MAC_ID_WIFI1
#define LANTXO_MAC_ID_USB         MAC_ID_USB
#define LANTXO_MAC_ID_MOCA        MAC_ID_MOCA
#define LANTXO_MAC_ID_WIFI0_GST   MAC_ID_WIFI0_GST
#define LANTXO_MAC_ID_WIFI1_GST   MAC_ID_WIFI1_GST
#define LANTXO_MAC_ID_ITC         MAC_ID_APPS_ROUTED
#define LANTXO_MAC_ID_APPS        MAC_ID_APPS_ROUTED
#define LANTXO_MAC_ID_EROUTER     MAC_ID_EROUTER

#define LANTXO_REL_TKN_MASK    0x00200000
#define LANTXO_REL_TKN_SHIFT   21
#define LANTXO_STS_REQ_BIT     0x00100000
#define LANTXO_STS_REQ_SHIFT   20
#define LANTXO_QOS_MASK        0x000f0000
#define LANTXO_QOS_SHIFT       16
#define LANTXO_SUB_ID_MASK     0x0000f000
#define LANTXO_SUB_ID_SHIFT    12
#define LANTXO_EOP_MASK        0x00000800
#define LANTXO_EOP_SHIFT       11
#define LANTXO_OFFSET_MASK     0x000007ff
#define LANTXO_OFFSET_SHIFT    0
#define LANTXSKB_LEN_MASK      LANTXO_OFFSET_MASK
#define LANTXSKB_LEN_SHIFT     LANTXO_OFFSET_SHIFT
    union {
        uint32_t token;     /* FPM */
        uint32_t context;   /* SKB */
    };
    uint32_t addr;          /* SKB */
};


#endif
