 /****************************************************************************
 *
 * Copyright (c) 2023-2023 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef BRCM_SMC_OTP_H
#define BRCM_SMC_OTP_H

#include <linux/ioctl.h>

/* Common request structure for SMC to perform OTP operation */
/* Buffer length should be at least 3k bits for OTP set/get */
struct smc_otp_req {
	__u8  otp_name[16];
	__u32 otp_field_id;
	__u32 otp_bits;
	void  *buffer;
   __u32 buff_length;
};

#define SMCOTP_DEV             "/dev/smc_otp"

#define SMC_OTP_IOC_MAGIC 'S'

#define SMC_OTP_IOCTL_GET_OTP    _IOW(SMC_OTP_IOC_MAGIC, 1, struct smc_otp_req)
#define SMC_OTP_IOCTL_SET_OTP    _IOW(SMC_OTP_IOC_MAGIC, 2, struct smc_otp_req)
#define SMC_OTP_IOCTL_COMMIT_OTP _IOW(SMC_OTP_IOC_MAGIC, 3, struct smc_otp_req)
#define SMC_OTP_IOCTL_LOCK_OTP   _IOW(SMC_OTP_IOC_MAGIC, 4, struct smc_otp_req)

#endif
