/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayesh.patel@broadcom.com>
 ***************************************************************************/

#ifndef _MDQM_H
#define _MDQM_H


typedef int (*mdqm_handler_t)(int id, u32 *msgdata, void *ctx);

struct mdqm_cb {
	mdqm_handler_t	handler;
	const char	*name;
	void		*dev_id;
	void		*ctx;
};

int mdqm_register(char *mdqmdev_name, struct mdqm_cb *cb);
int mdqm_unregister(char *mdqmdev_name, int cb_id);
int mdqm_send(char *mdqmdev_name, u32 *msgdata);
void *mdqm_to_dqm_h(char *mdqmdev_name, int num);
int mdqm_send_priority(char *mdqmdev_name, int priority, u32 *msgdata);
int mdqm_enable(char *mdqmdev_name);
int mdqm_disable(char *mdqmdev_name);
int mdqm_enable_id(char *mdqmdev_name, int cb_id);
int mdqm_disable_id(char *mdqmdev_name, int cb_id);
int mdqm_create(char *mdqmdev_name, char *dqmdev_name, char *qtype, u32 qcnt, u32 *qs);
int mdqm_delete(char *mdqmdev_name);

#endif
