 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

//
//****************************************************************************
//
//  $Id$
//
//  Filename:       bcmtypes.h
//  Author:         [author]
//  Creation Date:  [date]
//
//****************************************************************************
//  Description:
//
//
//
//
//
//****************************************************************************
//
// bcmtypes.h - misc useful typedefs
//
#ifndef BCMTYPES_H
#define BCMTYPES_H

#ifdef WIFI_TYPEDEFS_H
#include <typedefs.h>
#else

// sys/types.h defines UCHAR, USHORT, UINT, and ULONG (under pSOS).  It's
// safer to include it here.
#if (defined( __KERNEL__) || defined(TARGETOS_Linux))
  #include <linux/types.h>
#else
  #include <sys/types.h>
#endif

#if defined( TARGETOS_eCos ) || defined( TARGETOS_Qnx6 ) || defined( TARGETOS_Linux )
  #include "types.h"
#endif

// These are also defined in typedefs.h in the application area, so I need to
// protect against re-definition.
#ifndef TYPEDEFS_H

typedef unsigned char   byte;
typedef unsigned char   uint8;
typedef unsigned short  uint16;
typedef unsigned long   uint32;
typedef long long       int64;
typedef signed char     int8;
typedef signed short    int16;
typedef signed long     int32;

typedef unsigned long   BcmHandle;

#endif
#ifndef uint64
	#define uint64 unsigned long long
#endif

typedef unsigned long   semaphore_t;

typedef unsigned long   *PULONG,DWORD,*PDWORD;
typedef signed long     LONG,*PLONG;

typedef unsigned int    *PUINT;
typedef signed int      INT;

typedef unsigned short  *PUSHORT;
typedef signed short    SHORT,*PSHORT,WORD,*PWORD;

typedef unsigned char   *PUCHAR;
typedef signed char     *PCHAR;

typedef void            *PVOID;

typedef unsigned char   BOOLEAN, *PBOOL, *PBOOLEAN;

typedef unsigned char   BYTE,*PBYTE;

#ifndef TARGETOS_vxWorks
//The following has been defined in Vxworks internally: vxTypesOld.h
//redefine under vxworks will cause error

typedef signed int      *PINT;

#ifndef NUMBER_TYPES_ALREADY_DEFINED
#define NUMBER_TYPES_ALREADY_DEFINED
typedef signed char     INT8;
typedef signed short    INT16;
typedef signed long     INT32;
typedef signed long     sint32;
#define SINT32 sint32
typedef signed long long SINT64;

typedef unsigned char   UINT8;
typedef unsigned short  UINT16;
typedef unsigned long   UINT32;
typedef unsigned long long UINT64;
#endif

#ifndef BASE_TYPE_ALREADY_DEFINED
#define BASE_TYPE_ALREADY_DEFINED
typedef unsigned char   UCHAR;
typedef unsigned short  USHORT;
typedef unsigned int    UINT;
typedef unsigned long   ULONG;
#endif

typedef void            VOID;
typedef unsigned char   BOOL;

#else
// This doesn't really belong here, but it avoids a lot of weirdness elsewhere.  msieweke
#include <types/vxTypesOld.h>
#endif  /* TARGETOS_vxWorks */


// These are also defined in typedefs.h in the application area, so I need to
// protect against re-definition.
#ifndef TYPEDEFS_H

#define MAX_INT16 32767
#define MIN_INT16 -32768

// Useful for true/false return values.  This uses the
// Taligent notation (k for constant).
typedef enum
{
    kFalse = 0,
    kTrue = 1
} Bool;

#endif

/* macros to protect against unaligned accesses */

/* first arg is an address, second is a value */
#define PUT16( a, d ) { 		\
  *((byte *)a) = (byte)((d)>>8); 	\
  *(((byte *)a)+1) = (byte)(d); 	\
}

#define PUT32( a, d ) { 		\
  *((byte *)a) = (byte)((d)>>24); 	\
  *(((byte *)a)+1) = (byte)((d)>>16); 	\
  *(((byte *)a)+2) = (byte)((d)>>8); 	\
  *(((byte *)a)+3) = (byte)(d); 	\
}

/* first arg is an address, returns a value */
#define GET16( a ) ( 			\
  (*((byte *)a) << 8) |			\
  (*(((byte *)a)+1))	 		\
)

#define GET32( a ) ( 			\
  (*((byte *)a) << 24)     |		\
  (*(((byte *)a)+1) << 16) | 		\
  (*(((byte *)a)+2) << 8)  | 		\
  (*(((byte *)a)+3))	 		\
)

#if 1 //MSN
/* Register Macros to handle shadow register writing for
   bitfields.  This macro handles read modify writes.    */
#define ReadModWrField(reg, type, field, value)                                     \
{                                                                                   \
        type local_##type;				   	                                        \
        local_##type.Reg32 = reg.Reg32;                                             \
        local_##type.Reg32 = (local_##type.Reg32 &                                  \
                              ~(type##_##field##_MASK << type##_##field##_SHIFT));  \
        local_##type.Reg32 = (local_##type.Reg32 |                                  \
                              (value << type##_##field##_SHIFT));                   \
        reg.Reg32 = local_##type.Reg32;                                             \
}

/* Register Macros to handle shadow register writing for
   bitfields.  This macro handles write onlys.           */
#define WrField(reg, type, field, value)                                            \
{                                                                                   \
        type local_##type;				   	                                        \
        local_##type.Reg32 = reg.Reg32;                                             \
        local_##type.Reg32 = (local_##type.Reg32 &                                  \
                              ~(type##_##field##_MASK << type##_##field##_SHIFT));  \
        local_##type.Reg32 = (local_##type.Reg32 |                                  \
                              (value << type##_##field##_SHIFT));                   \
        reg.Reg32 = local_##type.Reg32;                                             \
}

/* Register Macros to handle shadow register writing for
   bitfields.  This macro handles read onlys.           */
#define ReadField(reg, type, field, value)      	\
{                                               	\
	type local_##type;				   	        	\
	local_##type.Reg32 = reg.Reg32;             	\
	value = ((local_##type.Reg32 >>					\
			  type##_##field##_SHIFT) & 			\
			  type##_##field##_MASK);				\
}

#else

/* Register Macros to handle shadow register writing for
   bitfields.  This macro handles read modify writes.    */
#define ReadModWrField(reg, type, field, value) \
{                                               \
	type local_##type;				   	        \
	local_##type.Reg32 = reg.Reg32;             \
	local_##type.Bits.field = value;            \
	reg.Reg32 = local_##type.Reg32;             \
}


/* Register Macros to handle shadow register writing for
   bitfields.  This macro handles write onlys.           */
#define WrField(reg, type, field, value)        \
{                                               \
	type local_##type;				   	        \
	local_##type.Bits.field = value;            \
	reg.Reg32 = local_##type.Reg32;             \
}


/* Register Macros to handle shadow register writing for
   bitfields.  This macro handles read onlys.           */
#define ReadField(reg, type, field, value)      \
{                                               \
	type local_##type;				   	        \
	local_##type.Reg32 = reg.Reg32;             \
	value = local_##type.Bits.field;            \
}


/* Register Macros to handle shadow register writing for
   8 bit bitfields.  This macro handles write onlys.           */
#define WrField8(reg, type, field, value)        \
{                                               \
	type local_##type;				   	        \
	local_##type.Bits.field = value;            \
	reg.Reg8 = local_##type.Reg8;             \
}


/* Register Macros to handle shadow register writing for
   bitfields.  This macro handles read onlys.           */
#define ReadField8(reg, type, field, value)      \
{                                               \
	type local_##type;				   	        \
	local_##type.Reg8 = reg.Reg8;             \
	value = local_##type.Bits.field;            \
}

#endif

/* General bit enable */
enum
{
    ONE  = 1,
    ZERO = 0
};


#ifndef YES
#define YES 1
#endif

#ifndef NO
#define NO  0
#endif

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#endif /* WIFI_TYPEDEFS_H */

#endif
