/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2022 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Broadcom Power Domain RPC interface.
 *
 * Author: Venky Selvaraj <venky.selvaraj@broadcom.com>
 *****************************************************************************/
#ifndef _BRCM_PWR_RPC_PRIV_H_
#define _BRCM_PWR_RPC_PRIV_H_

#define PWR_RPC_OF_MATCH "brcm,brcm-pwr-rpc"
#define ANSI_BLACK	"\e[30;1m"
#define ANSI_RED	"\e[31;1m"
#define ANSI_GREEN	"\e[32;1m"
#define ANSI_YELLOW	"\e[33;1m"
#define ANSI_BLUE	"\e[34;1m"
#define ANSI_MAGENTA	"\e[35;1m"
#define ANSI_CYAN	"\e[36;1m"
#define ANSI_WHITE	"\e[37;1m"
#define ANSI_RESET	"\e[0m"
#define BLK(str)	ANSI_BLK str ANSI_RESET
#define RED(str)	ANSI_RED str ANSI_RESET
#define GRN(str)	ANSI_GREEN str ANSI_RESET
#define YLW(str)	ANSI_YELLOW str ANSI_RESET
#define BLU(str)	ANSI_BLUE str ANSI_RESET
#define MAG(str)	ANSI_MAGENTA str ANSI_RESET
#define CYN(str)	ANSI_CYAN str ANSI_RESET
#define WHT(str)	ANSI_WHITE str ANSI_RESET
#define PWR_DOMAIN_NAME_MAX_LEN 9

#define MBOX(i) (info->mbox + (i<<2))
/* In case register layout changes */
#define SET_CPU_COMM_MBOX_READ_MASK(x) (0x0000FFFF & x) /*bitmask 0-16 to reg*/
#define GET_CPU_COMM_MBOX_READ_MASK(x) (u16)(0x0000FFFF & x) /*reg to bitmask*/
#define MBOX_BIT(x) (1 << x) /* mbox # to register mask bit */

#define CPU_COMM_REGS_CPUC_L2_IRQ_ARM0_MASK (info->comm+0x50)
#define CPU_COMM_REGS_CPUC_L2_IRQ_ARM1_MASK (info->comm+0x58)
#define CPU_COMM_REGS_CPUC_L2_IRQ_ARM2_MASK (info->comm+0x60)
#define CPU_COMM_REGS_CPUC_L2_IRQ_ARM3_MASK (info->comm+0x68)
#define CPU_COMM_REGS_CPUC_L2_IRQ_ARM0_STATUS (info->comm+0x54)
#define CPU_COMM_REGS_CPUC_L2_IRQ_ARM1_STATUS (info->comm+0x5C)
#define CPU_COMM_REGS_CPUC_L2_IRQ_ARM2_STATUS (info->comm+0x64)
#define CPU_COMM_REGS_CPUC_L2_IRQ_ARM3_STATUS (info->comm+0x6C)

#define BATT_POWER_STATE_MASK 0x3
#define BATT_POWER_STATE_SHIFT	2
#define R32(var, reg) var = readl_relaxed(reg)
#define W32(reg, val) writel_relaxed(val, reg)
#define SWF32(reg, fld, val) do { reg = \
	((reg&~(fld##_MASK<<fld##_SHIFT)) | \
	((val&fld##_MASK)<<fld##_SHIFT)); \
	} while (0)

/**
* enum mbox_io_idx - Index to device tree register IO memory
*/
enum mbox_io_idx {
	IO_MEM_MBOX,
	IO_MEM_COMM
};

typedef struct {
	int id;
	char name[PWR_DOMAIN_NAME_MAX_LEN];
	int state;
	int reset;
	bool registered;
} pwr_domain;

/*
* struct brcm_pwr_rpc_dev_info - Device info
* @pdev: platform device
* @states: MBOX register values
* @state_lock: lock for MBOX value storage
* @irq: IRQ from device tree
* @read_mask: mask of mbox #'s that can be read (from DT)
* @reg_status: Register to use for status (depends on STB vs. RG)
* @reg_mask: Register to use for mask (depends on STB vs. RG)
* @mbox: MBOX registers
* @comm: COMM registers
*/
struct brcm_pwr_rpc_dev_info {
	struct platform_device *pdev;
	struct brcm_pwr_rpc_mbox_info states;
	spinlock_t state_lock; /* lock for MBOX value storage */
	int irq;
	u32 read_mask;
	bool override_battery_state;
	void __iomem *reg_status;
	void __iomem *reg_mask;
	void __iomem *mbox;
	void __iomem *comm;
	const char *cpuc_irq;
};

int pwr_rpc_pseudo_clk_setup(struct device_node *node);

#endif //_BRCM_PWR_RPC_PRIV_H_
