 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2015-2016 Broadcom. All rights reserved.
 * The term Broadcom refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include "sfap.h"
#include "bcmnethooks.h"

static struct sfap_inf interface[MAX_INTERFACES];
static int interface_num;

int sfap_inf_num(void)
{
	return interface_num;
}

int sfap_inf_add(int type, char *name)
{
	struct net_device *dev;
	struct sfap_inf *inf;
	if (interface_num >= MAX_INTERFACES)
		return -1;
	dev = dev_get_by_name(&init_net, name);
	if (!dev)
		return -1;
	inf = sfap_inf_get_by_dev(dev);
	if (inf) {
		/* If interface exist, enable it*/
		inf->flags = 1;
		return 0;
	}
	memset(&interface[interface_num], 0, sizeof(struct sfap_inf));
	interface[interface_num].type = type;
	interface[interface_num].dev = dev;
	interface[interface_num].index = interface_num;
	interface[interface_num].flags = 1;
	interface_num++;
	return 0;
}

void sfap_inf_stats_clear(struct sfap_inf *inf)
{
	memset(&(inf->rx_stats), 0, sizeof(struct sfap_stats));
	memset(&(inf->tx_stats), 0, sizeof(struct sfap_stats));
}

struct sfap_inf *sfap_inf_get_by_index(int idx)
{
	if (idx < sfap_inf_num())
		return &interface[idx];
	return NULL;
}

struct sfap_inf *sfap_inf_get_by_dev(struct net_device *dev)
{
	int i;
	for (i = 0; i < sfap_inf_num(); i++) {
		if (interface[i].dev == dev)
			return &interface[i];
	}
	return NULL;
}

struct sfap_inf *sfap_inf_get_by_dev_ifindex(int ifindex)
{
	int i;
	for (i = 0; i < sfap_inf_num(); i++) {
		if (interface[i].dev->ifindex == ifindex)
			return &interface[i];
	}
	return NULL;
}

struct sfap_inf *sfap_inf_get_by_name(char *name)
{
	int i;
	for (i = 0; i < sfap_inf_num(); i++) {
		if (strcasecmp(interface[i].dev->name, name) == 0)
			return &interface[i];
	}
	return NULL;
}


int sfap_process_packet(struct sk_buff *skb, int len, struct net_device *dev)
{
	struct sfap_inf *i_inf = sfap_inf_get_by_dev(dev);
	struct sfap_inf *o_inf;
	int o_idx;
	if (i_inf) {
		i_inf->rx_stats.packets++;
		i_inf->rx_stats.bytes += len;
		/*if (!skb_ensure_writable(skb, skb->len )) {
			return -1;
		}*/
		o_idx = sfap_flow_mainp_pkt(skb->data-ETH_HLEN, len, dev);
		if (o_idx != -1) {
			o_inf = sfap_inf_get_by_index(o_idx);
			o_inf->tx_stats.packets++;
			o_inf->tx_stats.bytes += skb->len;
			/* print_hex_dump(KERN_DEBUG, "", DUMP_PREFIX_NONE, 16,
				       1, skb->data, skb->len, true); */
			skb->pkt_type = PACKET_FASTROUTE;
			/* Push - Reverse of what is done in eth_type_trans */
			skb_push(skb, ETH_HLEN);
			o_inf->dev->netdev_ops->ndo_start_xmit(skb, o_inf->dev);
			return 0;
		}
	}

	return -1;
}

int sfap_process_packet_fpm(struct fpm_buff *fpmb, struct net_device *dev)
{
	struct sfap_inf *i_inf = sfap_inf_get_by_dev(dev);
	struct sfap_inf *o_inf;
	int o_idx;
	if (i_inf) {
		i_inf->rx_stats.packets++;
		i_inf->rx_stats.bytes += fpmb->len;
		o_idx = sfap_flow_mainp_pkt(fpmb->data, fpmb->len, dev);
		if (o_idx != -1) {
			o_inf = sfap_inf_get_by_index(o_idx);
			o_inf->tx_stats.packets++;
			o_inf->tx_stats.bytes += fpmb->len;
			/* print_hex_dump(KERN_DEBUG, "", DUMP_PREFIX_NONE, 16,
				       1, fpmb->data, fpmb->len, true); */
			if (netif_running(o_inf->dev) &&
			    netif_carrier_ok(o_inf->dev))
				bcm_nethook_tx_fpm(fpmb, o_inf->dev);
			return 0;
		}
	}

	return -1;
}

void sfap_inf_show(void)
{
	int i;
	pr_info("Network Interface List: ");
	for (i = 0; i < sfap_inf_num(); i++) {
		if (!interface[i].flags)
			continue;
		pr_info(" %-10s", interface[i].dev->name);
	}
	pr_info("\n----------------------\n");
}
