 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/ip.h>

#include <net/netfilter/nf_conntrack_core.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/netfilter/nf_conntrack_expect.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_helper.h>
#include "nf_conntrack_rsvp.h"

static int
rsvp_convert_ip(struct rsvp_hdr *rsvph, struct rsvp_session_hdr *rsvpsh, __be32 ip)
{
	rsvpsh->ipAddress = ip;
	rsvph->checksum = 0;
	rsvph->checksum = ip_compute_csum((void *)rsvph, ntohs(rsvph->length));
	return NF_ACCEPT;
}

static int __init init(void)
{
	pr_debug("nf_nat_rsvp: init success\n");
	BUG_ON(nf_nat_rsvp_convert_ip_hook != NULL);
	RCU_INIT_POINTER(nf_nat_rsvp_convert_ip_hook, rsvp_convert_ip);
	return 0;
}

static void __exit fini(void)
{
	RCU_INIT_POINTER(nf_nat_rsvp_convert_ip_hook, NULL);
	synchronize_rcu();
}

module_init(init);
module_exit(fini);

MODULE_AUTHOR("Broadcom Corporation");
MODULE_DESCRIPTION("RSVP NAT helper");
MODULE_LICENSE("GPL");
MODULE_ALIAS("ip_nat_rsvp");
