 /****************************************************************************
 *
 * Copyright (c) 2016 Broadcom Limited
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayesh.patel@broadcom.com>
 *****************************************************************************/
#ifndef _DQSKB_PRIV_H_
#define _DQSKB_PRIV_H_

#include <linux/netdevice.h>
#include <linux/interrupt.h>
#include "dqm.h"
#include <proc_cmd.h>

#define MODULE_NAME		"brcm-dqskb"
#define MODULE_VER		"1.0"

struct dqskb_dev {
	struct platform_device *pdev;
	struct proc_dir_entry  *proc_dir;
	struct proc_cmd_table  *cmd_tbl;
	struct net_device      napi_dev;
	struct napi_struct     napi;
	struct tasklet_struct  tx_tasklet;
	int                    pkt_size;
	int                    autofill;
	int                    headroom;
	char                   name[16];
	int                    id;
	char                   dqm_dev[16];
	u32                    tx_q;
	u32                    rx_q;
	void                   *tx_q_h;
	void                   *rx_q_h;
	u8                     tx_q_tok_size;
	u8                     rx_q_tok_size;
	atomic_t               cnt_new;
	atomic_t               cnt_free;
	u32                    cnt_rxint;
	u32                    cnt_txint;
	atomic_t               cnt_rxpush;
	atomic_t               cnt_err;
};

int dqskb_parse_dt_node(struct platform_device *pdev);

#endif
