 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

/****************************************************************************
*	Filename:       bcmunimac_dt.h
*	Author:         Mark Newcomer/Tim Ross
*	Creation Date:  5/6/2013
*	PURPOSE: Common Functions for the Unimac driver.
******************************************************************************/
#ifndef _BCMUNIMAC_DT_H_
#define _BCMUNIMAC_DT_H_

#include <linux/types.h>
#include <linux/platform_device.h>
#include <linux/of.h>

int bcmunimac_parse_dt_prop_u32(struct device_node *of_node,
				const char *propname, u32 *dst);
int bcmunimac_parse_dt_prop_string(struct device_node *of_node,
				   const char *propname, char **dst);
int bcmunimac_parse_dt_prop_u32_array(struct device_node *of_node,
				      const char *propname, int cols,
				      int *rows, u32 *dst);
int bcmunimac_parse_dt_node(struct platform_device *pdev);
#endif /* _BCMUNIMAC_DT_H_ */
