/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#ifndef _DQNET_DBG_H_
#define _DQNET_DBG_H_

#include <linux/types.h>
#include <linux/netdevice.h>

extern const u32 dqnet_default_msg;

#define NETIF_MSG_DROP		(NETIF_MSG_WOL << 1)
#define netif_msg_drop(p)	((p)->msg_enable & NETIF_MSG_DROP)

#define show_dbg_pkt_desc(pd) \
do { \
	pr_debug("%s, %d\n", __func__, __LINE__); \
	pr_debug("if id:      %d\n", (pd)->if_id); \
	pr_debug("if sub id:  %d\n", (pd)->if_sub_id); \
	pr_debug("priority:   %d\n", (pd)->priority); \
	if ((pd)->type == BUF_TYPE_FPM) { \
		pr_debug("offset:     0x%08x\n", (pd)->offset); \
		pr_debug("token:      0x%08x\n", (pd)->token); \
		pr_debug("buf:        %px\n", (pd)->buf); \
		pr_debug("data:       %px\n", (pd)->data); \
		pr_debug("len:        0x%08x\n", (pd)->len); \
	} else { \
		pr_debug("skb:        %px\n", (pd)->skb); \
		pr_debug("head:       %px\n", (pd)->skb->head); \
		pr_debug("data:       %px\n", (pd)->skb->data); \
		pr_debug("len:        0x%08x\n", (pd)->skb->len); \
	} \
} while (0);

#define show_err_pkt_desc(pd) \
do { \
	pr_err("%s, %d\n", __func__, __LINE__); \
	pr_err("if id:      %d\n", (pd)->if_id); \
	pr_err("if sub id:  %d\n", (pd)->if_sub_id); \
	pr_err("priority:   %d\n", (pd)->priority); \
	if ((pd)->type == BUF_TYPE_FPM) { \
		pr_err("offset:     0x%08x\n", (pd)->offset); \
		pr_err("token:      0x%08x\n", (pd)->token); \
		pr_err("buf:        %px\n", (pd)->buf); \
		pr_err("data:       %px\n", (pd)->data); \
		pr_err("len:        0x%08x\n", (pd)->len); \
	} else { \
		pr_err("skb:        %px\n", (pd)->skb); \
		pr_err("head:       %px\n", (pd)->skb->head); \
		pr_err("data:       %px\n", (pd)->skb->data); \
		pr_err("len:        0x%08x\n", (pd)->skb->len); \
	} \
} while (0);

#define show_dbg_pkt(data, len) \
	print_hex_dump_bytes("", DUMP_PREFIX_NONE, data, len)

#define show_err_pkt(data, len) \
	print_hex_dump(KERN_ERR, "", DUMP_PREFIX_NONE, 16, 1, \
		       data, len, true)

#define show_rx_pkt(priv, data, len) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_RX_STATUS) && \
	    ((priv)->msg_enable & NETIF_MSG_PKTDATA)) \
		show_err_pkt((data), (len)); \
} while (0)

#define show_tx_pkt(priv, data, len) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_TX_DONE) && \
	    ((priv)->msg_enable & NETIF_MSG_PKTDATA)) \
		show_err_pkt((data), (len)); \
} while (0)

#define show_rx_pkt_desc(priv, pd) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_RX_STATUS)) \
		show_err_pkt_desc((pd)); \
} while (0)

#define show_tx_pkt_desc(priv, pd) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_TX_DONE)) \
		show_err_pkt_desc((pd)); \
} while (0)

#define show_drop_pkt(priv, data, len) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_DROP) && \
	    ((priv)->msg_enable & NETIF_MSG_PKTDATA)) \
		show_err_pkt((data), (len)); \
} while (0)

#define show_drop_pkt_desc(priv, pd) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_DROP)) \
		show_err_pkt_desc((pd)); \
} while (0)

#define show_rx_err_pkt(priv, data, len) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_RX_ERR) && \
	    ((priv)->msg_enable & NETIF_MSG_PKTDATA)) \
		show_err_pkt((data), (len)); \
} while (0)

#define show_tx_err_pkt(priv, data, len) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_TX_ERR) && \
	    ((priv)->msg_enable & NETIF_MSG_PKTDATA)) \
		show_err_pkt((data), (len)); \
} while (0)

#define show_rx_err_pkt_desc(priv, pd) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_RX_ERR)) \
		show_err_pkt_desc((pd)); \
} while (0)

#define show_tx_err_pkt_desc(priv, pd) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_TX_ERR)) \
		show_err_pkt_desc((pd)); \
} while (0)

#define show_rx_dbg_pkt(priv, data, len) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_RX_ERR) && \
	     ((priv)->msg_enable & NETIF_MSG_PKTDATA)) \
		show_dbg_pkt((data), (len)); \
} while (0)

#define show_tx_dbg_pkt(priv, data, len) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_TX_ERR) && \
	     ((priv)->msg_enable & NETIF_MSG_PKTDATA)) \
		show_dbg_pkt((data), (len)); \
} while (0)

#define show_rx_dbg_pkt_desc(priv, pd) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_RX_ERR)) \
		show_dbg_pkt_desc((pd)); \
} while (0)

#define show_tx_dbg_pkt_desc(priv, pd) \
do { \
	if (((priv)->msg_enable & NETIF_MSG_TX_ERR)) \
		show_dbg_pkt_desc((pd)); \
} while (0)

#endif
