/****************************************************************************
*
* Broadcom Proprietary and Confidential. (c) 2017 Broadcom.  All rights reserved.
* The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
*
* Unless you and Broadcom execute a separate written software license
* agreement governing use of this software, this software is licensed to
* you under the terms of the GNU General Public License version 2 (the
* "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
* the following added to such license:
*
* As a special exception, the copyright holders of this software give you
* permission to link this software with independent modules, and to copy
* and distribute the resulting executable under terms of your choice,
* provided that you also meet, for each linked independent module, the
* terms and conditions of the license of that module. An independent
* module is a module which is not derived from this software. The special
* exception does not apply to any modifications of the software.
*
* Notwithstanding the above, under no circumstances may you combine this
* software in any way with any other Broadcom software provided under a
* license other than the GPL, without Broadcom's express prior written
* consent.
*
****************************************************************************
*
* Filename: miimdiomux.h
*
****************************************************************************
* Description: RGMII and MDIO Mux Init header
* Author: Tim Ross <tross@broadcom.com>
****************************************************************************/

#ifndef _MIIMDIOMUX_H
#define _MIIMDIOMUX_H

#include <linux/kernel.h>

#define MUX_MAX_NAME_LEN	32
#define MUX_MAX_VALUES		4

struct miimdiomux_priv {
	void __iomem *mux_reg;
};

struct mux_value {
	char name[MUX_MAX_NAME_LEN];
	int val;
};

struct mux_select {
	char name[MUX_MAX_NAME_LEN];
	u32 mask;
	int shift;
	struct mux_value value_map[MUX_MAX_VALUES];
	int value_map_size;
};

int miimdiomux_select(struct platform_device *pdev,
		const char *mux_select_name, const char *mux_value_name);
#endif
