/****************************************************************************
 *
 * Broadcom Proprietary and Confidential. (c) 2016 Broadcom.  All rights reserved.
 * The term Broadcom refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 *
 * Filename: oamhook.h
 *
 ****************************************************************************
 * Description: header file for oamhook module
 *
 *
 ****************************************************************************/

#ifndef __OAMHOOK_H
#define __OAMHOOK_H

#define OAM_PKT_HDR_LEN					24
#define OAM_PKT_LLC_HDR_LEN				14

#define OAM_ETHER_TYPE					0x8809
#define OAM_SUB_TYPE					0x0a
#define OAM_VCM_LINK_FLAG0				0xfe
#define OAM_VCM_LINK_FLAG1				0x0e
#define OAM_VCM_LINK_FLAG2				0x00
#define OAM_VCM_LINK_FLAG3				0x0d
#define OAM_VCM_LINK_FLAG4				0xb6
#define OAM_VCM_LINK_FLAG5				0xc8

#define OAM_SUB_TYPE_OFF				14
#define OAM_PROTOCOL_TYPE_OFF				18
#define OAM_CORRECTION_TAG_OFF				20
#define OAM_LENGTH_OFF					22
#define OAM_PING_FLAG_OFF				24
#define OAM_OPCODE_OFF					26
#define OAM_VCM_LINK_FLAG_OFF				29
#define OAM_VCM_LINK_STATE_OFF				35

enum oam_proto_type {
	OAM_PROTO_PING					= 0,
	OAM_PROTO_ENCAPFRAME				= 1,
	OAM_PROTO_OAMPDUCODEANDDATA			= 2,
	OAM_PROTO_BCMSDKAPI				= 3,
	OAM_PROTO_REGOAMPDUANDDATA			= 4,
	OAM_PROTO_MASTERCOMMAND				= 5,
	OAM_PROTO_UNKNOWNFRAME				= 0x7ffe
};

enum oam_ping_type {
	OAM_PING_UNSATISFIED				= 0,
	OAM_PING_SATISFIED				= 1,
	OAM_PING_PAUSE					= 0x8000,
	OAM_PING_UNDEFINE				= 0x7999
};

enum oam_oampducodeanddata_content_type {
	OAM_OAMPDUCODEANDDATA_CONTENT_NORMAL,
	OAM_OAMPDUCODEANDDATA_CONTENT_VCMLINKNOTIFY,
	OAM_OAMPDUCODEANDDATA_CONTENT_UNKNOWN
};

#endif
