 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#include <linux/module.h>
#include <linux/udp.h>
#include <linux/ip.h>

#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_helper.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/netfilter/nf_conntrack_expect.h>
#include "nf_conntrack_ipsec.h"

MODULE_AUTHOR("Pavan Kumar <pavank@broadcom.com>");
MODULE_DESCRIPTION("Netfilter connection tracking module for ipsec");
MODULE_LICENSE("GPL");
MODULE_ALIAS("nf_nat_ipsec");

/* outbound packets == from LAN to WAN */
static int
ipsec_outbound_pkt(struct sk_buff *skb,
		   struct nf_conn *ct, enum ip_conntrack_info ctinfo)
{
	struct iphdr *iph = ip_hdr(skb);
	struct udphdr *udph = (void *)iph + iph->ihl * 4;

	/* make sure source port is 500 */
	udph->source = htons(IPSEC_PORT);
	udph->check = 0;

	return NF_ACCEPT;
}


/* inbound packets == from WAN to LAN */
static int
ipsec_inbound_pkt(struct sk_buff *skb, struct nf_conn *ct,
		  enum ip_conntrack_info ctinfo, __be32 lan_ip)
{
	struct iphdr *iph = ip_hdr(skb);
	struct udphdr *udph = (void *)iph + iph->ihl * 4;

	iph->daddr = lan_ip;
	udph->check = 0;
	iph->check = 0;
	iph->check = ip_fast_csum((unsigned char *)iph, iph->ihl);

	return NF_ACCEPT;
}

static int __init nf_nat_helper_ipsec_init(void)
{
	BUG_ON(nf_nat_ipsec_hook_outbound != NULL);
	RCU_INIT_POINTER(nf_nat_ipsec_hook_outbound, ipsec_outbound_pkt);

	BUG_ON(nf_nat_ipsec_hook_inbound != NULL);
	RCU_INIT_POINTER(nf_nat_ipsec_hook_inbound, ipsec_inbound_pkt);

	return 0;
}

static void __exit nf_nat_helper_ipsec_fini(void)
{
	RCU_INIT_POINTER(nf_nat_ipsec_hook_inbound, NULL);
	RCU_INIT_POINTER(nf_nat_ipsec_hook_outbound, NULL);

	synchronize_rcu();
}

module_init(nf_nat_helper_ipsec_init);
module_exit(nf_nat_helper_ipsec_fini);
