/*
 * Broadcom oops capture and display (boops)
 *
 * Copyright (C) 2017 Broadcom
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include "boops_shared.h"
#include "boops_k_storage.h"

#ifndef BOOPS_K_COMMON_H
#define BOOPS_K_COMMON_H

extern char g_boops_current_boot_uuid[BOOPS_UUID_SIZE];
extern char g_storage_type[BOOPS_STORAGE_TYPE_LENGTH];

#define boops_err(fmt, ...)  pr_err("[boops%s] ERROR: " fmt, g_storage_type, ##__VA_ARGS__)
#define boops_info(fmt, ...) pr_info("[boops%s] " fmt, g_storage_type, ##__VA_ARGS__)
#define boops_oops(fmt, ...) pr_info("[BOOPS]" fmt, ##__VA_ARGS__)

#endif //BOOPS_K_COMMON_H