/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#ifndef _DQNET_H_
#define _DQNET_H_

#include <linux/types.h>
#include <linux/if_link.h>
#include <linux/netfilter/nf_conntrack_common.h>

#define DQNET_DOR_API_V2
#define DQNET_DOR_TX_FLUSH

struct dqnet_dev_stats {
	struct rtnl_link_stats64	netdev;
	__u64				tx_multicast;
	__u64				rx_multicast_bytes;
	__u64				tx_multicast_bytes;
	__u64				rx_broadcast;
	__u64				tx_broadcast;
	__u64				rx_broadcast_bytes;
	__u64				tx_broadcast_bytes;
	__u64				rx_nethook_consumed;
	__u64				tx_nethook_consumed;
};

typedef int (*dqnet_dhdol_get_flow_t)(void* context, u8 *buf, int buf_len,
			unsigned char priority, int if_idx, int *radio, int *flowring);
typedef void *(*dqnet_dhdol_find_sta_t)(void *pub, int ifidx, void *ea);
typedef int (*dqnet_dhdol_tx_flush_t)(struct net_device *dev, int wifi_idx);

/*
 * DHD nethook TX callback is responsible for:
 *
 * 1)WMF multicast to unicast conversion -  The orignal packet is in skb. Any additional packets
 *   are queued in list.
 *
 * 2)WiFi metadata generation - metadata is stored in SKB control block for each packet.
 *
 * Return: bcm_nethook_result value
 */
typedef enum bcm_nethook_result (*dqnet_dhd_tx_skb_nethook_t)(void *context,
						int if_idx, struct sk_buff *skb,
						struct sk_buff_head *list);

/*
 * DHD nethook RX callback is responsible for:
 *
 * 1)Snooping the ingress packets to build the database for WMF.
 *
 * 2)Indicating whether the ingress packet should be transmitted
 * back to the BSS (intra BSS traffic).
 *
 * Return: bcm_nethook_result value
 */
typedef enum bcm_nethook_result (*dqnet_dhd_rx_skb_nethook_t)(void *context,
						int if_idx, struct sk_buff *skb);

typedef struct dqnet_dhdol_info {
	void	*dhd_cntx;
	dqnet_dhdol_get_flow_t	dhdol_get_flow;
	dqnet_dhdol_find_sta_t	dhdol_find_sta;
	dqnet_dhd_tx_skb_nethook_t	dhd_tx_skb_nethook;
	dqnet_dhd_rx_skb_nethook_t	dhd_rx_skb_nethook;
	dqnet_dhdol_tx_flush_t  dhdol_tx_flush;
} dqnet_dhdol_info_t ;

typedef struct dqnet_hostdrv_info_t {
	void	*cntx;
} dqnet_hostdrv_info_t ;

int dqnet_wifi_open_ext(struct net_device *dev, int if_id, int if_sub_id,
		    dqnet_dhdol_info_t *info);
#ifdef DQNET_DOR_API_V2
int dqnet_wifi_open_ext2(struct net_device *dev, int if_id, int if_sub_id,
		    dqnet_dhdol_info_t *info);
#endif
int dqnet_wifi_open(struct net_device *dev, int if_id, int if_sub_id);
int dqnet_wifi_close(struct net_device *dev);
int dqnet_priv_data_size(void);

int dqnet_hostdrv_open(struct net_device *dev, int if_id, int if_sub_id,
		       dqnet_hostdrv_info_t *info);
int dqnet_hostdrv_close(struct net_device *dev);

void *dqnet_register_napi_complete(void *dev, void (*napi_complete_hook)(void *));
void dqnet_unregister_napi_complete(void *chan);

static inline enum ip_conntrack_info nfctinfo(const struct sk_buff *skb)
{
        unsigned long nfct = skb_get_nfct(skb);

	return nfct & NFCT_INFOMASK;
}

#endif
