DESCRIPTION = "libubox open source package"
LICENSE = "GPLv2+"
LIC_FILES_CHKSUM = "file://CMakeLists.txt;md5=d5f602430bb69a43f64348682cc3dd38"

S = "${WORKDIR}/git/"

SRC_URI = "git://nbd.name/luci2/libubox.git;protocol=git;name=sourceCode \
           ${@bb.utils.contains("DISTRO_FEATURES", "dunfell", "file://qtn_libubox_cmake.patch", "file://qtn_libubox_cmake_kirkstone.patch",d)} \
           file://0001-blobmsg-fix-array-out-of-bounds-GCC-10-warning.patch \
           file://0001-Remove_deprecated_bits_header_file.patch \
           "
SRCREV_sourceCode = "e6376a0eecfd8df8ce992d2b90f93e1a0828c06e"

PV = "git${SRCPV}"

DEPENDS = "json-c"

inherit pkgconfig cmake
PACKAGES = "${PN}"
FILES_${PN} = "${base_libdir}/libubox.so*"
INSANE_SKIP_${PN} += " installed-vs-shipped"
EXTRA_OECMAKE_append_morty = "-DBUILD_LUA=OFF -DJSONC_FOUND=1 -DJSONC_INCLUDE_DIRS=${STAGING_INCDIR}/json-c"

do_install () {

        install -d ${D}${includedir}/libubox
        install -m 644 ${S}/*.h ${D}${includedir}/libubox

        install -d ${D}${libdir}
        install -m 644 ${B}/libubox.so ${D}${libdir}

        mkdir -p ${D}/lib
        install -m 644 ${B}/libubox.so -T ${D}/lib/libubox.so

}
