/*
 * Copyright © 2009-2016 Broadcom
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * A copy of the GPL is available at
 * http://www.broadcom.com/licenses/GPLv2.php or from the Free Software
 * Foundation at https://www.gnu.org/licenses/ .
 */

/*
 * **********************
 * READ ME BEFORE EDITING
 * **********************
 *
 * If you update this file, make sure to bump BRCMSTB_H_VERSION if there is an
 * API change!
 */

#ifndef _ASM_BRCMSTB_BRCMSTB_H
#define _ASM_BRCMSTB_BRCMSTB_H

#define BRCMSTB_H_VERSION  22

#if !defined(__ASSEMBLY__)

#include <linux/types.h>
#include <linux/smp.h>
#include <linux/device.h>
#include <linux/brcmstb/memory_api.h>
#include <linux/brcmstb/irq_api.h>
#include <linux/brcmstb/gpio_api.h>
#include <linux/brcmstb/reg_api.h>
#include <linux/brcmstb/clk_api.h>
#include <linux/brcmstb/reset_api.h>

#if defined(CONFIG_MIPS)
#include <asm/addrspace.h>
#include <asm/mipsregs.h>
#include <asm/setup.h>
#include <irq.h>
#include <spaces.h>
#endif

/***********************************************************************
 * BCHP header lists
 *
 * NOTE: This section is autogenerated.  Do not edit by hand.
 ***********************************************************************/

#if 1 /* defined(CONFIG_BCM3390B0) */
#include <linux/brcmstb/3390b0/bchp_common.h>
#include <linux/brcmstb/3390b0/bchp_fpm_ctrl_fpm.h>
#include <linux/brcmstb/3390b0/bchp_fpm_pool_fpm.h>
#include <linux/brcmstb/3390b0/bchp_sun_top_ctrl.h>
#include <linux/brcmstb/3390b0/bchp_switch_acb.h>
#include <linux/brcmstb/3390b0/bchp_switch_core.h>
#include <linux/brcmstb/3390b0/bchp_switch_fcb.h>
#include <linux/brcmstb/3390b0/bchp_switch_indir_rw.h>
#include <linux/brcmstb/3390b0/bchp_switch_intrl2_0.h>
#include <linux/brcmstb/3390b0/bchp_switch_intrl2_1.h>
#include <linux/brcmstb/3390b0/bchp_switch_mdio.h>
#include <linux/brcmstb/3390b0/bchp_switch_reg.h>
#endif

#if defined(CONFIG_BRCMSTB_SCMI_VPUCOM)
#define BRCMSTB_SCMI_VPUCOM_ASYNC_SUPPORT
typedef void (*brcmstb_vpucom_callback_fn_t)(u32 *pmsg, size_t msg_words);
int brcmstb_vpucom_register_callback(brcmstb_vpucom_callback_fn_t callback);
int brcmstb_vpucom_unregister_callback(void);
int brcmstb_vpucom_send_vpu_msg(u32 *pmsg, size_t msg_words);
#endif

#if defined(CONFIG_BRCMSTB_PM) && !defined(CONFIG_MIPS)
/*
 * Exclude a given memory range from the MAC authentication process during S3
 * suspend/resume. Ranges are reset after each MAC (i.e., after each S3
 * suspend/resume cycle). Returns non-zero on error.
 */
int brcmstb_pm_mem_exclude(phys_addr_t addr, size_t len);
/* So users can determine whether the kernel provides this API */
#define BRCMSTB_HAS_PM_MEM_EXCLUDE

/* Add region to be hashed during S3 suspend/resume. */
int brcmstb_pm_mem_region(phys_addr_t addr, size_t len);
#define BRCMSTB_HAS_PM_MEM_REGION
#endif

#endif /* !defined(__ASSEMBLY__) */

#endif /* _ASM_BRCMSTB_BRCMSTB_H */
