 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

/****************************************************************************
*	Filename:       bcmunimac_priv.h
*	Author:         Mark Newcomer
*	Creation Date:  5/6/2013
*	PURPOSE: Common Functions for the Unimac driver.
******************************************************************************/

#ifndef _BCM_UNIMAC_H_
#define _BCM_UNIMAC_H_

#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/uts.h>
#include <linux/utsname.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/fcntl.h>
#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <linux/in.h>
#include <linux/slab.h>
#include <linux/uaccess.h>
#include <linux/string.h>
#include <linux/init.h>
#include <asm/io.h>
#include <linux/errno.h>
#include <linux/proc_fs.h>
#include <linux/string.h>
#include <linux/delay.h>
#include <linux/stddef.h>
#include <asm/atomic.h>
#include <linux/proc_fs.h>
#include <linux/types.h>
#include <linux/platform_device.h>
#include "fpm.h"
#include "bcmunimac_dt.h"

#define MODULE_VER		"2.0"
#define VER_STR			"v" MODULE_VER " " __DATE__ " " __TIME__
#define UNIMAC_DRV		"brcm-unimac"
#define UNIMAC_OF_MATCH		"brcm,unimac"
#define UNIMAC_DEV		"unimac"
#define UNIMAC_MAX_PORTS	2

#define IFACE_CTRL						0x000
#define IFACE_CTRL_RX_BYTE_PAD_MASK		0xfff00000
#define IFACE_CTRL_RX_BYTE_PAD_SHIFT	20
#define IFACE_CTRL_ONCHIP_PHY_MASK		0x00000400
#define IFACE_CTRL_ONCHIP_PHY_SHIFT		10

#define IFACE_CLR_MIB					0x004
#define IFACE_CLR_MIB_COUNTER_MASK		0x00000001
#define IFACE_CLR_MIB_COUNTER_SHIFT		0

#define IFACE_MIB_PKTMAX				0x010
#define IFACE_MIB_PKTMAX_SIZE_MASK		0x00003fff
#define IFACE_MIB_PKTMAX_SIZE_SHIFT		0

#define IFACE_EN_IRQ					0x020
#define IFACE_EN_IRQ_LINKUP_MASK		0x00001000
#define IFACE_EN_IRQ_LINKUP_SHIFT		12
#define IFACE_EN_IRQ_LINKDOWN_MASK		0x00000800
#define IFACE_EN_IRQ_LINKDOWN_SHIFT		11
#define IFACE_EN_IRQ_PPP_VAL_MASK		0x00000400
#define IFACE_EN_IRQ_PPP_VAL_SHIFT		10
#define IFACE_EN_IRQ_RX_FULL_MASK		0x00000200
#define IFACE_EN_IRQ_RX_FULL_SHIFT		9
#define IFACE_EN_IRQ_RUNT_TRUNC_MASK	0x00000100
#define IFACE_EN_IRQ_RUNT_TRUNC_SHIFT	8
#define IFACE_EN_IRQ_FRAME_TRUNC_MASK	0x00000080
#define IFACE_EN_IRQ_FRAME_TRUNC_SHIFT	7
#define IFACE_EN_IRQ_CRC_ERR_MASK		0x00000002
#define IFACE_EN_IRQ_CRC_ERR_SHIFT		1
#define IFACE_EN_IRQ_RX_ERR_MASK		0x00000001
#define IFACE_EN_IRQ_RX_ERR_SHIFT		0

#define IFACE_MDIO_CFG_CLK_DIV			0x030
#define IFACE_MDIO_CFG_CLK_DIV_MASK		0x000003f0
#define IFACE_MDIO_CFG_CLK_DIV_SHIFT	4

#define IFACE_RGMII_CTRL				0x034
#define IFACE_RGMII_CTRL_LINK_MASK		0x00000010
#define IFACE_RGMII_CTRL_LINK_SHIFT		4

#define IFACE_EN_DROP_PKT					0x01c
#define IFACE_EN_DROP_PKT_RX_FULL_MASK		0x00000200
#define IFACE_EN_DROP_PKT_RX_FULL_SHIFT		9
#define IFACE_EN_DROP_PKT_FRAME_TRUNC_MASK	0x00000080
#define IFACE_EN_DROP_PKT_FRAME_TRUNC_SHIFT	7
#define IFACE_EN_DROP_PKT_CRC_ERR_MASK		0x00000002
#define IFACE_EN_DROP_PKT_CRC_ERR_SHIFT		1
#define IFACE_EN_DROP_PKT_RX_ERR_MASK		0x00000001
#define IFACE_EN_DROP_PKT_RX_ERR_SHIFT		0

#define CORE_CMD							0x008
#define CORE_CMD_TX_PAUSE_IGNORE_MASK		0x10000000
#define CORE_CMD_TX_PAUSE_IGNORE_SHIFT		28
#define CORE_CMD_NO_LGTH_CHECK_MASK			0x01000000
#define CORE_CMD_NO_LGTH_CHECK_SHIFT		24
#define CORE_CMD_SW_RESET_MASK				0x00002000
#define CORE_CMD_SW_RESET_SHIFT				13
#define CORE_CMD_HD_ENA_MASK				0x00000400
#define CORE_CMD_HD_ENA_SHIFT				10
#define CORE_CMD_RX_PAUSE_IGNORE_MASK		0x00000100
#define CORE_CMD_RX_PAUSE_IGNORE_SHIFT		8
#define CORE_CMD_CRC_FWD_MASK				0x00000040
#define CORE_CMD_CRC_FWD_SHIFT				6
#define CORE_CMD_PROMIS_EN_MASK				0x00000010
#define CORE_CMD_PROMIS_EN_SHIFT			4
#define CORE_CMD_ETH_SPEED_MASK				0x0000000c
#define CORE_CMD_ETH_SPEED_SHIFT			2
#define CORE_CMD_RX_ENA_MASK				0x00000002
#define CORE_CMD_RX_ENA_SHIFT				1
#define CORE_CMD_TX_ENA_MASK				0x00000001
#define CORE_CMD_TX_ENA_SHIFT				0

#define CORE_MAC0							0x00c
#define CORE_MAC1							0x010

#define CORE_FRM_LEN						0x014
#define CORE_FRM_LEN_FL_MASK				0x00003fff
#define CORE_FRM_LEN_FL_SHIFT				0

#define RGMII_CNTRL						0x000
#define RGMII_CNTRL_MODE_EN				0x1

#define RGMII_RX_CLOCK_DELAY_CNTRL		0x008
#define RGMII_RX_CLOCK_DELAY_CNTRL_PWR	0x10

/*
 * unimac mib
 */
struct unimac_mib {
	u32 grfcs;  /* 0x00 */
	u32 grxcf;  /* 0x04 */
	u32 grxpf;  /* 0x08 */
	u32 grxuo;  /* 0x0c */
	u32 graln;  /* 0x10 */
	u32 grflr;  /* 0x14 */
	u32 grcde;  /* 0x18 */
	u32 grfcr;  /* 0x1c */
	u32 grovr;  /* 0x20 */
	u32 grjbr;  /* 0x24 */
	u32 grmtue; /* 0x28 */
	u32 rrpkt;  /* 0x2c */
	u32 rrund;  /* 0x30 */
	u32 rrfrg;  /* 0x34 */
	u32 rrbyt;  /* 0x38 */
	u32 grmca;  /* 0x3c */
	u32 grbca;  /* 0x40 */
	u32 gr64;   /* 0x44 */
	u32 gr127;  /* 0x48 */
	u32 gr255;  /* 0x4c */
	u32 gr511;  /* 0x50 */
	u32 gr1023; /* 0x54 */
	u32 gr1518; /* 0x58 */
	u32 gr1522; /* 0x5c */
	u32 gr2047; /* 0x60 */
	u32 gr4095; /* 0x64 */
	u32 gr9216; /* 0x68 */
	u32 grpkt;  /* 0x6c */
	u32 grbyt;  /* 0x70 */
	u32 gruc;   /* 0x74 */
	u32 grpok;  /* 0x78 */
	u32 unused0;
	u32 grcrc;  /* 0x80 */
	u32 gtxpf;  /* 0x84 */
	u32 gtjbr;  /* 0x88 */
	u32 gtfcs;  /* 0x8c */
	u32 gtxcf;  /* 0x90 */
	u32 gtovr;  /* 0x94 */
	u32 gtdrf;  /* 0x98 */
	u32 gtedf;  /* 0x9c */
	u32 gtscl;  /* 0xa0 */
	u32 gtmcl;  /* 0xa4 */
	u32 gtlcl;  /* 0xa8 */
	u32 gtxcl;  /* 0xac */
	u32 gtfrg;  /* 0xb0 */
	u32 gtncl;  /* 0xb4 */
	u32 gtmca;  /* 0xb8 */
	u32 gtbca;  /* 0xbc */
	u32 tr64;   /* 0xc0 */
	u32 tr127;  /* 0xc4 */
	u32 tr255;  /* 0xc8 */
	u32 tr511;  /* 0xcc */
	u32 tr1023; /* 0xd0 */
	u32 tr1518; /* 0xd4 */
	u32 tr1522; /* 0xd8 */
	u32 tr2047; /* 0xdc */
	u32 tr4095; /* 0xe0 */
	u32 tr9216; /* 0xe4 */
	u32 gtpkt;  /* 0xe8 */
	u32 gtbyt;  /* 0xec */
	u32 gtuc;   /* 0xf0 */
	u32 gtpok;  /* 0xf4 */
};

/*
 * unimac device context
 */
struct unimac_device {
	u32	instance;
	void	*reg_base;
	u32	unimac_irq;
	u32	mbdma_irq;
	u32	fpm_rxbuffer_offset;
	u32	fpm_rxbuffer_pad;
	u32	skip_mbdma_init;
	u32	use_scb;
	u32	burst_size;
	u32	onchip_phy;
	u32	mbdma_channel0_rx_macid;
	u32	mbdma_channel0_tx_macid;
	u32	mbdma_channel1_rx_macid;
	u32	mbdma_channel1_tx_macid;
	u32 unimac_iface_offset;
	u32 unimac_core_offset;
	u32 unimac_mib_offset;
	u32 iface_control_reg;
	u32 iface_clear_mib_reg;
	u32 iface_mib_pktmax;
	u32 iface_enable_irq_reg;
	u32 iface_mdio_cfg_clk_div_reg;
	u32 iface_rgmii_ctrl_reg;
	u32 iface_enable_drop_pkt_reg;
	u32 core_cmd_reg;
	u32 core_mac0_reg;
	u32 core_mac1_reg;
	u32 core_frame_len_reg;
	int	verbosity;
	u32	rgmii_id_mode_disable;
	u32	tx_clk_dly;
	u32	rx_clk_dly;
	bool	in_use;
};

#define SET_FLD(local_reg, field, value) \
{ \
	local_reg = (local_reg & ~(field##_MASK)); \
	local_reg = (local_reg |  (((value) << field##_SHIFT) & \
							   field##_MASK)); \
}

#define GET_FLD(local_reg, field) ((local_reg & field##_MASK) >> \
								   field##_SHIFT)

#define GMAC_MAX_FRAME_LENGTH	2048
#define MAX_DOCSIS_HDR_LENGTH	32
/* GMAC Clock freq (160Mhz / (2 * 0x28) = 2.5mhz) */
#define GMAC_CLK_DIVIDER		0x1f

/*
 * Enable all 9 bits except AllocFifoFull and AllocFifoEmpty and Invalid Token
 * and FreeFifoEmpty.  Everything else is on.
 */
#define GMAC_MBDMA_INT_ENABLE	0x2e1

#endif /* _BCM_UNIMAC_H_ */
