/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __BRCMSTB_SOC_H
#define __BRCMSTB_SOC_H

static inline u32 BRCM_ID(u32 reg)
{
	return reg >> 28 ? reg >> 16 : reg >> 8;
}

static inline u32 BRCM_REV(u32 reg)
{
	return reg & 0xff;
}

/*
 * Helper functions for getting family or product id from the
 * SoC driver.
 */
u32 brcmstb_get_family_id(void);
u32 brcmstb_get_product_id(void);
u32 brcmstb_get_manufact_id(void);
u32 brcmstb_get_manufact_bits(void);
u32 brcmstb_get_manufact_mask(void);
u32 brcmstb_get_manufact_shift(void);
u32 brcmcm_get_variant_id(void);

int brcmstb_regsave_init(void);

#endif /* __BRCMSTB_SOC_H */
