DESCRIPTION = "libuci open source package"
LICENSE = "GPLv2+"
LIC_FILES_CHKSUM = "file://CMakeLists.txt;md5=988873da836b1f3455efd8e358cc58ac"

S = "${WORKDIR}/git/"

SRC_URI = "git://nbd.name/uci.git;protocol=git;name=sourceCode"
SRCREV_sourceCode = "a6a745338cd004a88edaaace5ca145a4411cdda9"
SRC_URI += " file://qtn_libuci_build_lua_off.patch"

PV = "git${SRCPV}"
inherit pkgconfig cmake
PACKAGES = "${PN}"
FILES_${PN} = "${base_libdir}/libuci.so*"
INSANE_SKIP_${PN} += " installed-vs-shipped"

DEPENDS = "qtn-libubox"
EXTRA_OECMAKE_append_morty = "-DBUILD_LUA=OFF -DJSONC_FOUND=1 -DJSONC_INCLUDE_DIRS=${STAGING_INCDIR}/json-c"

do_install () {

	install -d ${D}${includedir}
        if ${@bb.utils.contains('DISTRO_FEATURES', 'dunfell', 'true', 'false', d)}; then
            install ${S}/uci*.h ${D}${includedir}
        else
            install ${S}/*.h ${D}${includedir}
        fi
	
	install -d ${D}${libdir}
	install -m 644 ${B}/libuci.so ${D}${libdir}/
	
	install -d ${D}${base_libdir}/
	install -m 644 ${B}/libuci.so -T ${D}${base_libdir}/libuci.so	
}

do_install_append_morty() {
	rm -f ${D}${includedir}/list.h
}

SSTATE_ALLOW_OVERLAP_FILES += "${STAGING_INCDIR}/list.h"
