/****************************************************************************
 *
 * Copyright (c) 2021 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayeshp@broadcom.com>
 ***************************************************************************/

#ifndef _MACPT_H
#define _MACPT_H

extern int macpt_dbg;

#define	MACPT_DEBUG	1
#if MACPT_DEBUG
#define macpt_debug(a, ...) \
	do { \
		if (macpt_dbg) \
			pr_info(a, ##__VA_ARGS__); \
	} while (0)
#else
#define macpt_debug(a, ...)
#endif

/* MAC passthroug client DB Structure */
struct macpt_db_entry {
	struct hlist_node	hlist;

	struct rcu_head		rcu;
	int			ifindex;
	unsigned long		created;
	struct net_device	*dev;            /* Input Interface */
	atomic_t		use;             /* Use count       */
	__u8			addr[6];	 /* MAC address     */
};
void macpt_register_nethook(void);
void macpt_procfs_init(void);
void macpt_procfs_exit(void);

int macpt_db_init(void);
void macpt_db_fini(void);
struct macpt_db_entry *macpt_db_find(const unsigned char *addr);
int macpt_db_delete(const unsigned char *addr);
int macpt_db_insert(struct net_device *dev, const unsigned char *addr);
int macpt_db_update(struct net_device *dev, const unsigned char *addr);
void macpt_db_flush(void);

struct hlist_node  *macpt_db_get_first(int *hashid);
struct hlist_node *macpt_db_get_next(int *hashid,
				       struct hlist_node *head);
struct hlist_node *macpt_db_get_idx(int *hashid, loff_t pos);

int macpt_db_add(struct ndmsg *ndm, struct nlattr *tb[],
		 struct net_device *dev,
		 const unsigned char *addr,
		 u16 vid,
		 u16 flags,
		 struct netlink_ext_ack *extack);
int macpt_db_del(struct ndmsg *ndm, struct nlattr *tb[],
		 struct net_device *dev,
		 const unsigned char *addr,
		 u16 vid);

#endif
