# This file is Confidential Information of CUJO LLC.
# Copyright (c) 2020 CUJO LLC. All rights reserved.

SUMMARY = "Netfilter lua module (iptables plugin)"
DESCRIPTION = ""
HOMEPAGE = "https://github.com/cujoai/nflua"
LICENSE = "GPLv2"

LIC_FILES_CHKSUM = "file://LICENSES;md5=ee3ff1baf4364261360a81e2efe0e4da"
DEPENDS += "iptables libbsd"
RDEPENDS_${PN} += "libbsd"

FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

SRCREV = "b22c00527be3529be68fc5286fae8522f09af7af"
SRC_URI = "git://github.com/cujoai/nflua.git \
	   file://0001-changes-for-calling-risky-function.patch \
          "

S = "${WORKDIR}/git"
inherit pkgconfig
LDFLAGS="`pkg-config --libs libbsd`"

TARGET_XTABLES_LIBDIR ?= "${libdir}/xtables"

# STAGING_ROOT is set to ${D} instead of ${STAGING_DIR_HOST} to avoid
# Makefile installing files directly into yocto's staging directory.
# Let the SYSROOT_DIRS do it's job automatically.
EXTRA_OEMAKE = "\
    BUILD_DIR=${S} \
    INSTALL_ROOT=${D} \
    STAGING_ROOT=${D} \
    CUJO_PREFIX=${CUJO_PREFIX} \
    CC='${CC}' \
    CFLAGS='${CFLAGS}' \
    TARGET_XTABLES_LIBDIR=${TARGET_XTABLES_LIBDIR} \
    BUILD_NF=0 \
    BUILD_TESTS=0 \
"

TARGET_CC_ARCH += "${LDFLAGS}"

do_install() {
    oe_runmake install
}

FILES_${PN} += "\
    ${CUJO_PREFIX}/lib/iptables/libxt_lua.so \
    ${TARGET_XTABLES_LIBDIR}/libxt_lua.so \
"

# Symlinks are expected in the *-dev package and not in any of the other
# packages. However, we need it, so skip the QA check, otherwise it will fail.
INSANE_SKIP_${PN} += "dev-so"