/*
 * Broadcom oops capture and display (boops)
 *
 * Copyright (C) 2017 Broadcom
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <linux/kernel.h>
#include <linux/types.h>

#include "boops_shared.h"
#include "boops_k_proc.h"

#ifndef BOOPS_K_H
#define BOOPS_K_H

struct boops_t {
    struct kmsg_dumper dump;
    struct boops_storage_t *storage;                                    /* The interface and geometry of the storage device */
    uint8_t* block_buffer;                                              /* Formatted oops dump data to be written to the device */
    size_t block_buffer_size;                                           /* Size of the block buffer */
    volatile uint32_t dump_requested;                                   /* Counts the number of times an oops dump callback has happened. We only dump on the first callback */
    volatile bool dump_completed;                                       /* Set to true once the dump has completed. False otherwise */
    struct boops_proc_t* boops_proc;                                    /* Boops proc interfaces */
    int32_t oops_dump_delay;                                            /* A counter for how long to delay on this device */
    bool simulation_mode;                                               /* Indicates the module has been used for a simulated oops. This is a one way setting. After a simulation the module should eb restarted to clear this */

    struct {
        uint32_t blocks;                                                /* The size (in blocks) of each writable segment */
        uint32_t bytes;                                                 /* The size (in bytes) of each writable segment */
        size_t count;                                                   /* The number of writable segments */
    } segment;
};

#if LINUX_VERSION_CODE >= KERNEL_VERSION(5,15,0)
    typedef bool (*boops_dump_get_buffer)(struct kmsg_dump_iter * iter, bool syslog, char * buf, size_t size, size_t * len);
#else
    typedef bool (*boops_dump_get_buffer)(struct kmsg_dumper * dumper,  bool syslog, char * buf, size_t size, size_t * len);
#endif

void boops_capture_oops(struct boops_t *boops, boops_dump_get_buffer get_buffer, void* context, enum kmsg_dump_reason reason);

#endif //BOOPS_K_H