 /****************************************************************************
 *
 * Copyright (c) 2015-2018 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayeshp@broadcom.com>
 ****************************************************************************/

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/inetdevice.h>
#include "bcmflow.h"
#include "flowmgr_fap_ops.h"
#include "sfap_api.h"

static int fap_enable(bool enable)
{
	return sfap_enable(enable);
}

static int fap_config(char *pri_lan_dev_name, char *wan_dev_name,
	       char *sec_lan_dev_name)
{
	return 0;
}

static int fap_config_mapt(void *params)
{
	return 0;
}

static int fap_config_dslite(void *params, int oindex)
{
	return 0;
}

static int fap_flow_add(void *ptr, int *flow_id)
{
	return sfap_flow_add(ptr, flow_id);
}

static int fap_flow_remove(int flow_id)
{
	return sfap_flow_remove(flow_id);
}

static int fap_flow_remove_mcast(int flow_id, __be32 *group_id,  int oindex)
{
	return 0;
}

static int fap_flow_get_counter(int flow_id, u32 *packets, u32 *bytes,
				bool reset)
{
	return sfap_flow_get_counter(flow_id, packets, bytes, reset);
}

static int fap_flow_get_mcast_counter(int flow_id, u32 *packets, u32 *bytes,
				bool reset)
{
	return 0;
}

static struct fap_ops fapops = {
	.type = SFAP,
	.name = "SW FAP",
	.features = (FLOW_F_TCP4 | FLOW_F_UDP4 |
		     FLOW_F_TCP6 | FLOW_F_UDP6 |
		     FLOW_F_MACBR),
	.enable = fap_enable,
	.config = fap_config,
	.config_dslite = fap_config_dslite,
	.config_mapt = fap_config_mapt,
	.flow_add = fap_flow_add,
	.flow_remove = fap_flow_remove,
	.flow_remove_mcast = fap_flow_remove_mcast,
	.flow_get_counter = fap_flow_get_counter,
	.flow_get_mcast_counter = fap_flow_get_mcast_counter
};

struct fap_ops *sfap(void)
{
	return &fapops;
}

static int __init flowmgr_sfap_init(void)
{
	flowmgr_register_fap(sfap());
	return 0;
}

static void __exit flowmgr_sfap_exit(void)
{
	flowmgr_unregister_fap(sfap());
}

module_init(flowmgr_sfap_init);
module_exit(flowmgr_sfap_exit);
MODULE_LICENSE("GPL");
MODULE_ALIAS("flowmgr_sfap");
